/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.ingredients.transform;

import com.blamejared.crafttweaker.CraftTweakerRegistries;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.transformed.IIngredientTransformer;
import com.blamejared.crafttweaker.api.item.transformed.IIngredientTransformerSerializer;
import com.blamejared.crafttweaker.impl.ingredients.IngredientNBT;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class TransformReplace<T extends IIngredient>
implements IIngredientTransformer<T> {
    private final IItemStack replaceWith;

    public TransformReplace(IItemStack replaceWith) {
        this.replaceWith = replaceWith;
    }

    @Override
    public IItemStack transform(IItemStack stack) {
        return new MCItemStack(this.replaceWith.getInternal().func_77946_l());
    }

    @Override
    public String getCommandString(T transformedIngredient) {
        return String.format("%s.transformReplace(%s)", transformedIngredient.getCommandString(), this.replaceWith.getCommandString());
    }

    @Override
    public IIngredientTransformerSerializer getSerializer() {
        return CraftTweakerRegistries.TRANSFORM_REPLACE_SERIALIZER;
    }

    public static final class TransformReplaceTransformerSerializer
    implements IIngredientTransformerSerializer<TransformReplace<?>> {
        @Override
        public TransformReplace<?> parse(PacketBuffer buffer) {
            ItemStack replaceWith = buffer.func_150791_c();
            return new TransformReplace(new MCItemStack(replaceWith));
        }

        @Override
        public TransformReplace<?> parse(JsonObject json) {
            Ingredient.IItemList iItemList = IngredientNBT.func_199803_a((JsonObject)json.getAsJsonObject("replaceWith"));
            ItemStack replaceWith = (ItemStack)iItemList.func_199799_a().iterator().next();
            return new TransformReplace(new MCItemStack(replaceWith));
        }

        @Override
        public void write(PacketBuffer buffer, TransformReplace<?> ingredient) {
            buffer.func_150788_a(((TransformReplace)ingredient).replaceWith.getInternal());
        }

        @Override
        public JsonObject toJson(TransformReplace<?> transformer) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("type", this.getType().toString());
            jsonObject.add("replaceWith", ((TransformReplace)transformer).replaceWith.asVanillaIngredient().func_200304_c());
            return jsonObject;
        }

        @Override
        public ResourceLocation getType() {
            return new ResourceLocation("crafttweaker", "transform_replace");
        }
    }
}

