/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.network.client;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.common.network.NetworkHandler;
import top.theillusivec4.polymorph.common.network.server.SPacketSyncOutput;

public class CPacketTransferRecipe {
    private final String recipe;

    public CPacketTransferRecipe(String recipe) {
        this.recipe = recipe;
    }

    public static void encode(CPacketTransferRecipe msg, PacketBuffer buf) {
        buf.func_180714_a(msg.recipe);
    }

    public static CPacketTransferRecipe decode(PacketBuffer buf) {
        return new CPacketTransferRecipe(buf.func_150789_c(Short.MAX_VALUE));
    }

    public static void handle(CPacketTransferRecipe msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender != null) {
                Container container = sender.field_71070_bA;
                PolymorphApi.getProvider(container).ifPresent(provider -> {
                    Optional result = sender.func_71121_q().func_199532_z().func_215367_a(new ResourceLocation(msg.recipe));
                    result.ifPresent(res -> {
                        if (res instanceof ICraftingRecipe) {
                            ICraftingRecipe craftingRecipe = (ICraftingRecipe)res;
                            provider.transfer((PlayerEntity)sender, craftingRecipe);
                        }
                    });
                });
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> sender), (Object)new SPacketSyncOutput(ItemStack.field_190927_a));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

