/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.network.client;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.common.network.NetworkHandler;
import top.theillusivec4.polymorph.common.network.server.SPacketSyncOutput;

public class CPacketSetRecipe {
    private final String recipe;

    public CPacketSetRecipe(String recipe) {
        this.recipe = recipe;
    }

    public static void encode(CPacketSetRecipe msg, PacketBuffer buf) {
        buf.func_180714_a(msg.recipe);
    }

    public static CPacketSetRecipe decode(PacketBuffer buf) {
        return new CPacketSetRecipe(buf.func_150789_c(Short.MAX_VALUE));
    }

    public static void handle(CPacketSetRecipe msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender != null) {
                Container container = sender.field_71070_bA;
                AtomicReference<ItemStack> output = new AtomicReference<ItemStack>(ItemStack.field_190927_a);
                PolymorphApi.getProvider(container).ifPresent(provider -> {
                    Slot slot = provider.getOutputSlot();
                    Optional result = sender.func_71121_q().func_199532_z().func_215367_a(new ResourceLocation(msg.recipe));
                    CraftingInventory finalCraftingInventory = provider.getCraftingInventory();
                    result.ifPresent(res -> {
                        ICraftingRecipe craftingRecipe;
                        if (res instanceof ICraftingRecipe && finalCraftingInventory != null && (craftingRecipe = (ICraftingRecipe)res).func_77569_a((IInventory)finalCraftingInventory, sender.field_70170_p)) {
                            output.set(craftingRecipe.func_77572_b((IInventory)finalCraftingInventory));
                            slot.field_75224_c.func_70299_a(slot.getSlotIndex(), (ItemStack)output.get());
                        }
                    });
                });
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> sender), (Object)new SPacketSyncOutput(output.get()));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

