/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.integrations.refinedstorage;

import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.grid.GridType;
import com.refinedmods.refinedstorage.api.network.grid.INetworkAwareGrid;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.api.util.IStackList;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.container.GridContainer;
import com.refinedmods.refinedstorage.tile.grid.portable.IPortableGrid;
import java.util.ArrayList;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.SlotItemHandler;
import top.theillusivec4.polymorph.api.PolyProvider;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.common.integrations.CompatibilityModule;

public class RefinedStorageModule
extends CompatibilityModule {
    @Override
    public void setup() {
        PolymorphApi.addProvider(GridContainer.class, GridProvider::new);
    }

    public static class GridProvider
    implements PolyProvider {
        private final GridContainer gridContainer;

        public GridProvider(GridContainer gridContainer) {
            this.gridContainer = gridContainer;
        }

        @Override
        public Container getContainer() {
            return this.gridContainer;
        }

        @Override
        public boolean isActive() {
            return this.gridContainer.getGrid().getGridType() == GridType.CRAFTING;
        }

        @Override
        public int getXOffset() {
            return 21;
        }

        @Override
        public int getYOffset() {
            return -42;
        }

        @Override
        public void transfer(PlayerEntity playerIn, ICraftingRecipe recipe) {
            Slot slot = (Slot)this.gridContainer.field_75151_b.get(this.getOutputSlot().field_75222_d);
            if (this.gridContainer.getGrid() instanceof IPortableGrid && slot instanceof SlotItemHandler && ((SlotItemHandler)slot).getItemHandler().equals(((IPortableGrid)this.gridContainer.getGrid()).getDisk())) {
                return;
            }
            if (this.gridContainer.getGrid() instanceof INetworkAwareGrid) {
                this.onCraftedShift((INetworkAwareGrid)this.gridContainer.getGrid(), playerIn, recipe);
            } else {
                this.gridContainer.getGrid().onCraftedShift(playerIn);
            }
            this.gridContainer.func_75142_b();
        }

        public void onCraftedShift(INetworkAwareGrid grid, PlayerEntity player, ICraftingRecipe recipe) {
            CraftingInventory matrix = grid.getCraftingMatrix();
            if (matrix != null) {
                INetwork network = grid.getNetwork();
                ArrayList<ItemStack> craftedItemsList = new ArrayList<ItemStack>();
                CraftResultInventory result = grid.getCraftingResult();
                ItemStack crafted = result != null ? result.func_70301_a(0) : ItemStack.field_190927_a;
                int maxCrafted = crafted.func_77976_d();
                int amountCrafted = 0;
                boolean useNetwork = network != null;
                IStackList<ItemStack> availableItems = null;
                if (useNetwork) {
                    availableItems = this.createFilteredItemList(network, matrix);
                }
                IStackList usedItems = API.instance().createItemStackList();
                ForgeHooks.setCraftingPlayer((PlayerEntity)player);
                do {
                    API.instance().getCraftingGridBehavior().onCrafted(grid, recipe, player, availableItems, usedItems);
                    craftedItemsList.add(crafted.func_77946_l());
                } while (API.instance().getComparer().isEqual(crafted, recipe.func_77572_b((IInventory)matrix)) && (amountCrafted += crafted.func_190916_E()) < maxCrafted && amountCrafted + crafted.func_190916_E() <= maxCrafted && recipe.func_77569_a((IInventory)matrix, player.field_70170_p));
                if (useNetwork) {
                    usedItems.getStacks().forEach(stack -> network.extractItem((ItemStack)stack.getStack(), ((ItemStack)stack.getStack()).func_190916_E(), Action.PERFORM));
                }
                for (ItemStack craftedItem : craftedItemsList) {
                    if (player.field_71071_by.func_70441_a(craftedItem.func_77946_l())) continue;
                    ItemStack remainder = craftedItem;
                    if (useNetwork) {
                        remainder = network.insertItem(craftedItem, craftedItem.func_190916_E(), Action.PERFORM);
                    }
                    if (remainder.func_190926_b()) continue;
                    InventoryHelper.func_180173_a((World)player.func_130014_f_(), (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (ItemStack)remainder);
                }
                crafted.func_77980_a(player.field_70170_p, player, amountCrafted);
                BasicEventHooks.firePlayerCraftingEvent((PlayerEntity)player, (ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)crafted, (int)amountCrafted), (IInventory)grid.getCraftingMatrix());
                ForgeHooks.setCraftingPlayer(null);
            }
        }

        private IStackList<ItemStack> createFilteredItemList(INetwork network, CraftingInventory matrix) {
            IStackList availableItems = API.instance().createItemStackList();
            for (int i = 0; i < matrix.func_70302_i_(); ++i) {
                ItemStack stack = (ItemStack)network.getItemStorageCache().getList().get((Object)matrix.func_70301_a(i));
                if (stack == null || availableItems.get((Object)stack) != null) continue;
                availableItems.add((Object)stack);
            }
            return availableItems;
        }
    }
}

