/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.WorkbenchContainer;
import top.theillusivec4.polymorph.api.PolyProvider;

public class PolymorphApi {
    private static final Map<Class<? extends Container>, Function<? extends Container, PolyProvider>> providerFunctions = new HashMap<Class<? extends Container>, Function<? extends Container, PolyProvider>>();

    public static <T extends Container> void addProvider(Class<T> clazz, Function<T, PolyProvider> providerFunction) {
        providerFunctions.put(clazz, providerFunction);
    }

    public static <T extends Container> Optional<PolyProvider> getProvider(T container) {
        Function<? extends Container, PolyProvider> providerFunction = providerFunctions.get(container.getClass());
        if (providerFunction == null) {
            if (container instanceof WorkbenchContainer) {
                providerFunction = providerFunctions.get(WorkbenchContainer.class);
            } else if (container instanceof PlayerContainer) {
                providerFunction = providerFunctions.get(PlayerContainer.class);
            }
        }
        return providerFunction != null ? Optional.of(providerFunction.apply(container)) : Optional.empty();
    }
}

