/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph;

import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.command.CommandSource;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.WorkbenchContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.client.ClientEventHandler;
import top.theillusivec4.polymorph.common.integrations.CompatibilityModule;
import top.theillusivec4.polymorph.common.integrations.craftingcraft.CraftingCraftModule;
import top.theillusivec4.polymorph.common.integrations.craftingstation.CraftingStationModule;
import top.theillusivec4.polymorph.common.integrations.fastbench.FastWorkbenchModule;
import top.theillusivec4.polymorph.common.integrations.jei.JeiModule;
import top.theillusivec4.polymorph.common.integrations.refinedstorage.RefinedStorageModule;
import top.theillusivec4.polymorph.common.integrations.silentgear.SilentGearModule;
import top.theillusivec4.polymorph.common.integrations.storagenetwork.StorageNetworkModule;
import top.theillusivec4.polymorph.common.network.NetworkHandler;
import top.theillusivec4.polymorph.common.provider.InventoryProvider;
import top.theillusivec4.polymorph.common.provider.WorkbenchProvider;
import top.theillusivec4.polymorph.server.PolymorphCommand;

@Mod(value="polymorph")
public class Polymorph {
    public static final String MODID = "polymorph";
    public static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, Supplier<CompatibilityModule>> INTEGRATIONS = new HashMap<String, Supplier<CompatibilityModule>>();
    private static final List<CompatibilityModule> ACTIVE_INTEGRATIONS = new ArrayList<CompatibilityModule>();

    public Polymorph() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
        ModList modList = ModList.get();
        INTEGRATIONS.forEach((modid, supplier) -> {
            if (modList.isLoaded(modid)) {
                ACTIVE_INTEGRATIONS.add((CompatibilityModule)supplier.get());
            }
        });
    }

    private void setup(FMLCommonSetupEvent evt) {
        NetworkHandler.register();
        PolymorphApi.addProvider(WorkbenchContainer.class, WorkbenchProvider::new);
        PolymorphApi.addProvider(PlayerContainer.class, InventoryProvider::new);
        ACTIVE_INTEGRATIONS.forEach(CompatibilityModule::setup);
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        ACTIVE_INTEGRATIONS.forEach(CompatibilityModule::clientSetup);
    }

    private void serverStarting(FMLServerStartingEvent evt) {
        PolymorphCommand.register((CommandDispatcher<CommandSource>)evt.getCommandDispatcher());
    }

    static {
        INTEGRATIONS.put("fastbench", FastWorkbenchModule::new);
        INTEGRATIONS.put("jei", JeiModule::new);
        INTEGRATIONS.put("silentgear", SilentGearModule::new);
        INTEGRATIONS.put("craftingstation", CraftingStationModule::new);
        INTEGRATIONS.put("storagenetwork", StorageNetworkModule::new);
        INTEGRATIONS.put("refinedstorage", RefinedStorageModule::new);
        INTEGRATIONS.put("craftingcraft", CraftingCraftModule::new);
    }
}

