/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.bumblezone.modcompatibility;

import com.github.commoble.potionofbees.ResourceLocations;
import com.github.commoble.potionofbees.SplashPotionOfBeesEntity;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.telepathicgrunt.bumblezone.Bumblezone;
import net.telepathicgrunt.bumblezone.blocks.BzBlocks;
import net.telepathicgrunt.bumblezone.blocks.HoneycombBrood;
import net.telepathicgrunt.bumblezone.modcompatibility.ModChecking;
import net.telepathicgrunt.bumblezone.modcompatibility.PotionOfBeesBeePotionDispenseBehavior;
import org.apache.logging.log4j.Level;

public class PotionOfBeesCompat {
    private static final PotionOfBeesBeePotionDispenseBehavior BEHAVIOUR_BOTTLED_BEE_DISPENSE_ITEM = new PotionOfBeesBeePotionDispenseBehavior();
    private static Item POTION_OF_BEES;
    private static Item SPLASH_POTION_OF_BEES;

    public static void setupPotionOfBees() {
        ModChecking.potionOfBeesPresent = true;
        POTION_OF_BEES = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocations.POTION_OF_BEES);
        SPLASH_POTION_OF_BEES = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocations.SPLASH_POTION_OF_BEES);
        try {
            Method method = ObfuscationReflectionHelper.findMethod(DispenserBlock.class, (String)"func_149940_a", (Class[])new Class[]{ItemStack.class});
            if (POTION_OF_BEES != null && Bumblezone.BzConfig.allowPotionOfBeesCompat.get().booleanValue()) {
                PotionOfBeesBeePotionDispenseBehavior.DEFAULT_POTION_BEE_DISPENSE_BEHAVIOR = (IDispenseItemBehavior)method.invoke((Object)Blocks.field_150367_z, new ItemStack((IItemProvider)POTION_OF_BEES));
                DispenserBlock.func_199774_a((IItemProvider)POTION_OF_BEES, (IDispenseItemBehavior)BEHAVIOUR_BOTTLED_BEE_DISPENSE_ITEM);
            } else {
                Bumblezone.LOGGER.log(Level.WARN, "Error trying to change the dispenser behavior for Potion of Bee's bee potion item. Please report this issue to Bumblezone author.");
            }
            if (SPLASH_POTION_OF_BEES != null && Bumblezone.BzConfig.allowSplashPotionOfBeesCompat.get().booleanValue()) {
                PotionOfBeesBeePotionDispenseBehavior.DEFAULT_SPLASH_POTION_BEE_DISPENSE_BEHAVIOR = (IDispenseItemBehavior)method.invoke((Object)Blocks.field_150367_z, new ItemStack((IItemProvider)SPLASH_POTION_OF_BEES));
                DispenserBlock.func_199774_a((IItemProvider)SPLASH_POTION_OF_BEES, (IDispenseItemBehavior)BEHAVIOUR_BOTTLED_BEE_DISPENSE_ITEM);
            } else {
                Bumblezone.LOGGER.log(Level.WARN, "Error trying to change the dispenser behavior for Potion of Bee's bee splash potion item. Please report this issue to Bumblezone author.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean POBIsPotionOfBeesItem(Item item) {
        return item == POTION_OF_BEES;
    }

    public static boolean POBIsSplashPotionOfBeesItem(Item item) {
        return item == SPLASH_POTION_OF_BEES;
    }

    public static void POBReviveLarvaBlockEvent(ProjectileImpactEvent.Throwable event) {
        Entity thrownEntity = event.getEntity();
        if (thrownEntity instanceof SplashPotionOfBeesEntity) {
            World world = thrownEntity.field_70170_p;
            Vec3d hitBlockPos = event.getRayTraceResult().func_216347_e();
            BlockPos originalPosition = new BlockPos(hitBlockPos);
            BlockPos.Mutable position = new BlockPos.Mutable(originalPosition);
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        position.func_189533_g((Vec3i)originalPosition).func_196234_d(x, y, z);
                        BlockState block = world.func_180495_p((BlockPos)position);
                        if (block.func_177230_c() != BzBlocks.DEAD_HONEYCOMB_BROOD.get()) continue;
                        PotionOfBeesCompat.reviveLarvaBlock(world, block, (BlockPos)position);
                    }
                }
            }
        }
    }

    private static void reviveLarvaBlock(World world, BlockState state, BlockPos position) {
        world.func_175656_a(position, (BlockState)((BlockState)((Block)BzBlocks.HONEYCOMB_BROOD.get()).func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H)))).func_206870_a((IProperty)HoneycombBrood.STAGE, (Comparable)Integer.valueOf(world.field_73012_v.nextInt(3))));
    }
}

