/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.bumblezone.modcompatibility;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockMatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.telepathicgrunt.bumblezone.Bumblezone;
import net.telepathicgrunt.bumblezone.biome.BzBaseBiome;
import net.telepathicgrunt.bumblezone.biome.BzBiomes;
import net.telepathicgrunt.bumblezone.modcompatibility.ModChecking;

public class BeesourcefulCompat {
    private static List<Block> HONEYCOMB_VARIANTS;
    private static List<EntityType<?>> BEE_VARIANTS;
    private static String FILLER_BLOCK_TARGET_ID;

    public static void setupBeesourceful() {
        ModChecking.beesourcefulPresent = true;
        if (Bumblezone.BzConfig.spawnBeesourcefulHoneycombVariants.get().booleanValue()) {
            OreFeatureConfig.FillerBlockType.create((String)FILLER_BLOCK_TARGET_ID.toUpperCase(), (String)FILLER_BLOCK_TARGET_ID, (Predicate)new BlockMatcher(Blocks.field_226908_md_));
            Block diamondHoneycomb = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("beesourceful:diamond_honeycomb_block"));
            Block emeraldHoneycomb = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("beesourceful:emerald_honeycomb_block"));
            Block enderHoneycomb = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("beesourceful:ender_honeycomb_block"));
            Block goldHoneycomb = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("beesourceful:gold_honeycomb_block"));
            Block ironHoneycomb = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("beesourceful:iron_honeycomb_block"));
            Block lapisHoneycomb = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("beesourceful:lapis_honeycomb_block"));
            Block redstoneHoneycomb = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("beesourceful:redstone_honeycomb_block"));
            BeesourcefulCompat.BSAddHoneycombs();
            HONEYCOMB_VARIANTS = new ArrayList<Block>();
            HONEYCOMB_VARIANTS.add(goldHoneycomb);
            HONEYCOMB_VARIANTS.add(ironHoneycomb);
            HONEYCOMB_VARIANTS.add(redstoneHoneycomb);
            HONEYCOMB_VARIANTS.add(lapisHoneycomb);
            HONEYCOMB_VARIANTS.add(emeraldHoneycomb);
            HONEYCOMB_VARIANTS.add(enderHoneycomb);
            HONEYCOMB_VARIANTS.add(diamondHoneycomb);
        }
        BEE_VARIANTS = new ArrayList();
        BEE_VARIANTS.add((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("beesourceful:ender_bee")));
        BEE_VARIANTS.add((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("beesourceful:diamond_bee")));
        BEE_VARIANTS.add((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("beesourceful:emerald_bee")));
        BEE_VARIANTS.add((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("beesourceful:lapis_bee")));
        BEE_VARIANTS.add((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("beesourceful:quartz_bee")));
        BEE_VARIANTS.add((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("beesourceful:gold_bee")));
        BEE_VARIANTS.add((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("beesourceful:redstone_bee")));
        BEE_VARIANTS.add((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("beesourceful:iron_bee")));
    }

    public static void BSAddHoneycombs() {
        Block diamondHoneycomb = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("beesourceful:diamond_honeycomb_block"));
        Block emeraldHoneycomb = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("beesourceful:emerald_honeycomb_block"));
        Block enderHoneycomb = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("beesourceful:ender_honeycomb_block"));
        Block goldHoneycomb = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("beesourceful:gold_honeycomb_block"));
        Block ironHoneycomb = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("beesourceful:iron_honeycomb_block"));
        Block lapisHoneycomb = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("beesourceful:lapis_honeycomb_block"));
        Block redstoneHoneycomb = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("beesourceful:redstone_honeycomb_block"));
        BzBiomes.biomes.forEach(biome -> ((BzBaseBiome)((Object)biome)).func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.func_214736_a((String)FILLER_BLOCK_TARGET_ID), diamondHoneycomb.func_176223_P(), 7)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(1, 6, 0, 244)))));
        BzBiomes.biomes.forEach(biome -> ((BzBaseBiome)((Object)biome)).func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.func_214736_a((String)FILLER_BLOCK_TARGET_ID), emeraldHoneycomb.func_176223_P(), 4)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(1, 6, 0, 244)))));
        BzBiomes.biomes.forEach(biome -> ((BzBaseBiome)((Object)biome)).func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.func_214736_a((String)FILLER_BLOCK_TARGET_ID), enderHoneycomb.func_176223_P(), 4)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(1, 200, 0, 50)))));
        BzBiomes.biomes.forEach(biome -> ((BzBaseBiome)((Object)biome)).func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.func_214736_a((String)FILLER_BLOCK_TARGET_ID), goldHoneycomb.func_176223_P(), 34)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(3, 6, 0, 230)))));
        BzBiomes.biomes.forEach(biome -> ((BzBaseBiome)((Object)biome)).func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.func_214736_a((String)FILLER_BLOCK_TARGET_ID), ironHoneycomb.func_176223_P(), 26)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(2, 30, 0, 210)))));
        BzBiomes.biomes.forEach(biome -> ((BzBaseBiome)((Object)biome)).func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.func_214736_a((String)FILLER_BLOCK_TARGET_ID), lapisHoneycomb.func_176223_P(), 22)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(1, 6, 0, 30)))));
        BzBiomes.biomes.forEach(biome -> ((BzBaseBiome)((Object)biome)).func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.func_214736_a((String)FILLER_BLOCK_TARGET_ID), redstoneHoneycomb.func_176223_P(), 22)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(1, 30, 0, 210)))));
    }

    public static void BSMobSpawnEvent(LivingSpawnEvent.CheckSpawn event) {
        MobEntity entity = (MobEntity)event.getEntity();
        IWorld world = event.getWorld();
        int beeTypeChance = world.func_201674_k().nextInt(100);
        MobEntity beesourcefulBeeEntity = beeTypeChance < 1 ? (MobEntity)BEE_VARIANTS.get(0).func_200721_a(entity.field_70170_p) : (beeTypeChance < 3 ? (MobEntity)BEE_VARIANTS.get(1).func_200721_a(entity.field_70170_p) : (beeTypeChance < 10 ? (MobEntity)BEE_VARIANTS.get(2).func_200721_a(entity.field_70170_p) : (beeTypeChance < 20 ? (MobEntity)BEE_VARIANTS.get(3).func_200721_a(entity.field_70170_p) : (beeTypeChance < 30 ? (MobEntity)BEE_VARIANTS.get(4).func_200721_a(entity.field_70170_p) : (beeTypeChance < 50 ? (MobEntity)BEE_VARIANTS.get(5).func_200721_a(entity.field_70170_p) : (beeTypeChance < 70 ? (MobEntity)BEE_VARIANTS.get(6).func_200721_a(entity.field_70170_p) : (MobEntity)BEE_VARIANTS.get(7).func_200721_a(entity.field_70170_p)))))));
        BlockPos.Mutable blockpos = new BlockPos.Mutable(entity.func_180425_c());
        beesourcefulBeeEntity.func_70012_b((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), world.func_201674_k().nextFloat() * 360.0f, 0.0f);
        ILivingEntityData ilivingentitydata = null;
        ilivingentitydata = beesourcefulBeeEntity.func_213386_a(world, world.func_175649_E(new BlockPos((Entity)beesourcefulBeeEntity)), event.getSpawnReason(), ilivingentitydata, (CompoundNBT)null);
        world.func_217376_c((Entity)beesourcefulBeeEntity);
    }

    public static Block BSGetRandomHoneycomb(Random random, int lowerBoundBias) {
        int index = HONEYCOMB_VARIANTS.size() - 1;
        for (int i = 0; i < lowerBoundBias && index != 0; ++i) {
            index = random.nextInt(index + 1);
        }
        return HONEYCOMB_VARIANTS.get(index);
    }

    static {
        FILLER_BLOCK_TARGET_ID = "honeycomb_target";
    }
}

