/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.bumblezone.features;

import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.IClearable;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.BitSetVoxelShapePart;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;
import net.telepathicgrunt.bumblezone.Bumblezone;
import net.telepathicgrunt.bumblezone.blocks.BzBlocks;
import net.telepathicgrunt.bumblezone.blocks.HoneyCrystal;
import net.telepathicgrunt.bumblezone.blocks.HoneycombBrood;
import net.telepathicgrunt.bumblezone.modcompatibility.BeesourcefulRedirection;
import net.telepathicgrunt.bumblezone.modcompatibility.BuzzierBeesRedirection;
import net.telepathicgrunt.bumblezone.modcompatibility.ModChecking;
import net.telepathicgrunt.bumblezone.modcompatibility.ProductiveBeesRedirection;

public class BeeDungeon
extends Feature<NoFeatureConfig> {
    private static final BlockState HONEY_CRYSTAL = ((Block)BzBlocks.HONEY_CRYSTAL.get()).func_176223_P();

    public BeeDungeon(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> changedBlock, Random rand, BlockPos position, NoFeatureConfig p_212245_5_) {
        if (rand.nextInt(Bumblezone.BzConfig.beeDungeonRarity.get()) != 0) {
            return false;
        }
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable(position).func_196234_d(-6, -2, -6);
        TemplateManager templatemanager = ((ServerWorld)world.func_201672_e()).func_217485_w().func_186340_h();
        Template template = templatemanager.func_200219_b(new ResourceLocation("the_bumblezone:bee_dungeon/shell"));
        if (template == null) {
            Bumblezone.LOGGER.warn("bee_dungeon/shell NTB does not exist!");
            return false;
        }
        PlacementSettings placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186218_a((ChunkPos)null);
        BeeDungeon.addBlocksToWorld(template, world, (BlockPos)blockpos$Mutable, placementsettings, 2);
        template = templatemanager.func_200219_b(new ResourceLocation("the_bumblezone:bee_dungeon/altar"));
        if (template == null) {
            Bumblezone.LOGGER.warn("bee_dungeon/altar NTB does not exist!");
            return false;
        }
        BeeDungeon.addBlocksToWorld(template, world, (BlockPos)blockpos$Mutable.func_196234_d(0, 1, 0), placementsettings, 2);
        return true;
    }

    private static boolean addBlocksToWorld(Template template, IWorld world, BlockPos pos, PlacementSettings placementIn, int flags) {
        if (template.field_204769_a.isEmpty()) {
            return false;
        }
        List list = placementIn.func_227459_a_(template.field_204769_a, pos);
        if (!(list.isEmpty() && (placementIn.func_186221_e() || template.field_186271_b.isEmpty()) || template.field_186272_c.func_177958_n() < 1 || template.field_186272_c.func_177956_o() < 1 || template.field_186272_c.func_177952_p() < 1)) {
            MutableBoundingBox mutableboundingbox = placementIn.func_186213_g();
            ArrayList list1 = Lists.newArrayListWithCapacity((int)(placementIn.func_204763_l() ? list.size() : 0));
            ArrayList list2 = Lists.newArrayListWithCapacity((int)list.size());
            int i = Integer.MAX_VALUE;
            int j = Integer.MAX_VALUE;
            int k = Integer.MAX_VALUE;
            int l = Integer.MIN_VALUE;
            int i1 = Integer.MIN_VALUE;
            int j1 = Integer.MIN_VALUE;
            for (Template.BlockInfo template$blockinfo : Template.processBlockInfos((Template)template, (IWorld)world, (BlockPos)pos, (PlacementSettings)placementIn, (List)list)) {
                TileEntity tileentity1;
                BlockPos blockpos = template$blockinfo.field_186242_a;
                if (mutableboundingbox != null && !mutableboundingbox.func_175898_b((Vec3i)blockpos)) continue;
                IFluidState ifluidstate = placementIn.func_204763_l() ? world.func_204610_c(blockpos) : null;
                BlockState blockstate = template$blockinfo.field_186243_b.func_185902_a(placementIn.func_186212_b()).func_185907_a(placementIn.func_186215_c());
                if (template$blockinfo.field_186244_c != null) {
                    TileEntity tileentity = world.func_175625_s(blockpos);
                    IClearable.func_213131_a((Object)tileentity);
                    world.func_180501_a(blockpos, Blocks.field_180401_cv.func_176223_P(), 20);
                }
                Pair<BlockState, Boolean> pair = BeeDungeon.blockConversion(world, blockpos, blockstate.func_177230_c(), world.func_201674_k());
                blockstate = (BlockState)pair.getFirst();
                if (!((Boolean)pair.getSecond()).booleanValue() && !world.func_180495_p(blockpos).func_200132_m() || !world.func_180501_a(blockpos, blockstate, flags)) continue;
                i = Math.min(i, blockpos.func_177958_n());
                j = Math.min(j, blockpos.func_177956_o());
                k = Math.min(k, blockpos.func_177952_p());
                l = Math.max(l, blockpos.func_177958_n());
                i1 = Math.max(i1, blockpos.func_177956_o());
                j1 = Math.max(j1, blockpos.func_177952_p());
                list2.add(Pair.of((Object)blockpos, (Object)template$blockinfo.field_186244_c));
                if (template$blockinfo.field_186244_c != null && (tileentity1 = world.func_175625_s(blockpos)) != null) {
                    template$blockinfo.field_186244_c.func_74768_a("x", blockpos.func_177958_n());
                    template$blockinfo.field_186244_c.func_74768_a("y", blockpos.func_177956_o());
                    template$blockinfo.field_186244_c.func_74768_a("z", blockpos.func_177952_p());
                    tileentity1.func_145839_a(template$blockinfo.field_186244_c);
                    tileentity1.func_189668_a(placementIn.func_186212_b());
                    tileentity1.func_189667_a(placementIn.func_186215_c());
                }
                if (ifluidstate == null || !(blockstate.func_177230_c() instanceof ILiquidContainer)) continue;
                ((ILiquidContainer)blockstate.func_177230_c()).func_204509_a(world, blockpos, blockstate, ifluidstate);
                if (ifluidstate.func_206889_d()) continue;
                list1.add(blockpos);
            }
            boolean flag = true;
            Direction[] adirection = new Direction[]{Direction.UP, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
            while (flag && !list1.isEmpty()) {
                flag = false;
                Iterator iterator = list1.iterator();
                while (iterator.hasNext()) {
                    BlockState blockstate2;
                    Block block;
                    BlockPos blockpos2;
                    BlockPos blockpos3 = blockpos2 = (BlockPos)iterator.next();
                    IFluidState ifluidstate2 = world.func_204610_c(blockpos2);
                    for (int k1 = 0; k1 < adirection.length && !ifluidstate2.func_206889_d(); ++k1) {
                        BlockPos blockpos1 = blockpos3.func_177972_a(adirection[k1]);
                        IFluidState ifluidstate1 = world.func_204610_c(blockpos1);
                        if (!(ifluidstate1.func_215679_a((IBlockReader)world, blockpos1) > ifluidstate2.func_215679_a((IBlockReader)world, blockpos3)) && (!ifluidstate1.func_206889_d() || ifluidstate2.func_206889_d())) continue;
                        ifluidstate2 = ifluidstate1;
                        blockpos3 = blockpos1;
                    }
                    if (!ifluidstate2.func_206889_d() || !((block = (blockstate2 = world.func_180495_p(blockpos2)).func_177230_c()) instanceof ILiquidContainer)) continue;
                    ((ILiquidContainer)block).func_204509_a(world, blockpos2, blockstate2, ifluidstate2);
                    flag = true;
                    iterator.remove();
                }
            }
            if (i <= l) {
                if (!placementIn.func_215218_i()) {
                    BitSetVoxelShapePart voxelshapepart = new BitSetVoxelShapePart(l - i + 1, i1 - j + 1, j1 - k + 1);
                    int l1 = i;
                    int i2 = j;
                    int j2 = k;
                    for (Pair pair1 : list2) {
                        BlockPos blockpos5 = (BlockPos)pair1.getFirst();
                        voxelshapepart.func_199625_a(blockpos5.func_177958_n() - l1, blockpos5.func_177956_o() - i2, blockpos5.func_177952_p() - j2, true, true);
                    }
                    Template.func_222857_a((IWorld)world, (int)flags, (VoxelShapePart)voxelshapepart, (int)l1, (int)i2, (int)j2);
                }
                for (Pair pair : list2) {
                    TileEntity tileentity2;
                    BlockPos blockpos4 = (BlockPos)pair.getFirst();
                    if (!placementIn.func_215218_i()) {
                        BlockState blockstate3;
                        BlockState blockstate1 = world.func_180495_p(blockpos4);
                        if (blockstate1 != (blockstate3 = Block.func_199770_b((BlockState)blockstate1, (IWorld)world, (BlockPos)blockpos4))) {
                            world.func_180501_a(blockpos4, blockstate3, flags & 0xFFFFFFFE | 0x10);
                        }
                        world.func_195592_c(blockpos4, blockstate3.func_177230_c());
                    }
                    if (pair.getSecond() == null || (tileentity2 = world.func_175625_s(blockpos4)) == null) continue;
                    tileentity2.func_70296_d();
                }
            }
            if (!placementIn.func_186221_e()) {
                template.func_207668_a(world, pos, placementIn.func_186212_b(), placementIn.func_186215_c(), placementIn.func_207664_d(), placementIn.func_186213_g());
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Pair<BlockState, Boolean> blockConversion(IWorld world, BlockPos pos, Block block, Random random) {
        if (block == Blocks.field_196721_fC || block == Blocks.field_196795_fy) {
            if (ModChecking.beesourcefulPresent && (double)random.nextFloat() < Bumblezone.BzConfig.oreHoneycombSpawnRateBeeDungeon.get()) {
                return new Pair((Object)BeesourcefulRedirection.BSGetRandomHoneycomb(random, Bumblezone.BzConfig.PBGreatHoneycombRarityBeeDungeon.get()).func_176223_P(), (Object)false);
            }
            if (!ModChecking.beesourcefulPresent && ModChecking.productiveBeesPresent && (double)random.nextFloat() < Bumblezone.BzConfig.PBOreHoneycombSpawnRateBeeDungeon.get()) {
                return new Pair((Object)ProductiveBeesRedirection.PBGetRandomHoneycomb(random, Bumblezone.BzConfig.PBGreatHoneycombRarityBeeDungeon.get()).func_176223_P(), (Object)false);
            }
            if (!(random.nextFloat() < 0.4f)) return new Pair((Object)((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get()).func_176223_P(), (Object)false);
            return new Pair((Object)Blocks.field_226908_md_.func_176223_P(), (Object)false);
        }
        if (block == Blocks.field_196778_fp) {
            if (random.nextFloat() < 0.6f) {
                return new Pair((Object)((BlockState)((BlockState)((Block)BzBlocks.HONEYCOMB_BROOD.get()).func_176223_P().func_206870_a((IProperty)HoneycombBrood.STAGE, (Comparable)Integer.valueOf(random.nextInt(3)))).func_206870_a((IProperty)HoneycombBrood.field_176387_N, (Comparable)Direction.SOUTH)), (Object)false);
            }
            if (!(random.nextFloat() < 0.2f)) return new Pair((Object)((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get()).func_176223_P(), (Object)false);
            return new Pair((Object)Blocks.field_226907_mc_.func_176223_P(), (Object)false);
        }
        if (block == Blocks.field_196783_fs) {
            if (random.nextFloat() < 0.6f) {
                return new Pair((Object)((BlockState)((BlockState)((Block)BzBlocks.HONEYCOMB_BROOD.get()).func_176223_P().func_206870_a((IProperty)HoneycombBrood.STAGE, (Comparable)Integer.valueOf(random.nextInt(3)))).func_206870_a((IProperty)HoneycombBrood.field_176387_N, (Comparable)Direction.WEST)), (Object)false);
            }
            if (!(random.nextFloat() < 0.2f)) return new Pair((Object)((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get()).func_176223_P(), (Object)false);
            return new Pair((Object)Blocks.field_226907_mc_.func_176223_P(), (Object)false);
        }
        if (block == Blocks.field_196785_ft) {
            if (random.nextFloat() < 0.6f) {
                return new Pair((Object)((BlockState)((BlockState)((Block)BzBlocks.HONEYCOMB_BROOD.get()).func_176223_P().func_206870_a((IProperty)HoneycombBrood.STAGE, (Comparable)Integer.valueOf(random.nextInt(3)))).func_206870_a((IProperty)HoneycombBrood.field_176387_N, (Comparable)Direction.NORTH)), (Object)false);
            }
            if (!(random.nextFloat() < 0.2f)) return new Pair((Object)((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get()).func_176223_P(), (Object)false);
            return new Pair((Object)Blocks.field_226907_mc_.func_176223_P(), (Object)false);
        }
        if (block == Blocks.field_196797_fz) {
            if (random.nextFloat() < 0.6f) {
                return new Pair((Object)((BlockState)((BlockState)((Block)BzBlocks.HONEYCOMB_BROOD.get()).func_176223_P().func_206870_a((IProperty)HoneycombBrood.STAGE, (Comparable)Integer.valueOf(random.nextInt(3)))).func_206870_a((IProperty)HoneycombBrood.field_176387_N, (Comparable)Direction.EAST)), (Object)false);
            }
            if (!(random.nextFloat() < 0.2f)) return new Pair((Object)((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get()).func_176223_P(), (Object)false);
            return new Pair((Object)Blocks.field_226907_mc_.func_176223_P(), (Object)false);
        }
        if (block == BzBlocks.SUGAR_WATER_BLOCK.get()) {
            if (!(random.nextFloat() < 0.1f) || !HONEY_CRYSTAL.func_196955_c((IWorldReader)world, pos)) return new Pair((Object)block.func_176223_P(), (Object)false);
            return new Pair((Object)((BlockState)HONEY_CRYSTAL.func_206870_a((IProperty)HoneyCrystal.WATERLOGGED, (Comparable)Boolean.valueOf(true))), (Object)false);
        }
        if (block == Blocks.field_196720_fB) {
            boolean replaceAir = false;
            if (world.func_180495_p(pos.func_177984_a()).func_185904_a() != Material.field_151579_a && !world.func_180495_p(pos.func_177984_a()).func_200132_m()) {
                replaceAir = true;
            }
            if (ModChecking.beesourcefulPresent && (double)random.nextFloat() < Bumblezone.BzConfig.oreHoneycombSpawnRateBeeDungeon.get()) {
                return new Pair((Object)BeesourcefulRedirection.BSGetRandomHoneycomb(random, Bumblezone.BzConfig.greatHoneycombRarityBeeDungeon.get()).func_176223_P(), (Object)replaceAir);
            }
            if (!(random.nextFloat() < 0.4f)) return new Pair((Object)((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get()).func_176223_P(), (Object)replaceAir);
            return new Pair((Object)Blocks.field_226908_md_.func_176223_P(), (Object)replaceAir);
        }
        if (block == Blocks.field_196789_fv) {
            if (ModChecking.buzzierBeesPresent && Bumblezone.BzConfig.allowScentedCandlesBeeDungeon.get().booleanValue()) {
                if (random.nextFloat() < 0.25f && world.func_180495_p(pos.func_177977_b()).func_185904_a() != Material.field_151579_a) {
                    return new Pair((Object)BuzzierBeesRedirection.BBGetRandomTier1Candle(random, random.nextInt(3) + 1, false, true), (Object)true);
                }
                if (!(random.nextFloat() < 0.4f) || !HONEY_CRYSTAL.func_196955_c((IWorldReader)world, pos)) return new Pair((Object)Blocks.field_201941_jj.func_176223_P(), (Object)false);
                return new Pair((Object)HONEY_CRYSTAL, (Object)true);
            }
            if (!(random.nextFloat() < 0.2f) || !HONEY_CRYSTAL.func_196955_c((IWorldReader)world, pos)) return new Pair((Object)Blocks.field_201941_jj.func_176223_P(), (Object)false);
            return new Pair((Object)HONEY_CRYSTAL, (Object)true);
        }
        if (block == Blocks.field_196793_fx) {
            if (ModChecking.buzzierBeesPresent && Bumblezone.BzConfig.allowScentedCandlesBeeDungeon.get().booleanValue()) {
                if (random.nextFloat() < 0.4f && world.func_180495_p(pos.func_177977_b()).func_185904_a() != Material.field_151579_a) {
                    return new Pair((Object)BuzzierBeesRedirection.BBGetRandomTier2Candle(random, Bumblezone.BzConfig.powerfulCandlesRarityBeeDungeon.get(), random.nextInt(random.nextInt(3) + 1) + 1, false, true), (Object)true);
                }
                if (!random.nextBoolean() || !HONEY_CRYSTAL.func_196955_c((IWorldReader)world, pos)) return new Pair((Object)Blocks.field_201941_jj.func_176223_P(), (Object)false);
                return new Pair((Object)HONEY_CRYSTAL, (Object)true);
            }
            if (!(random.nextFloat() < 0.35f) || !HONEY_CRYSTAL.func_196955_c((IWorldReader)world, pos)) return new Pair((Object)Blocks.field_201941_jj.func_176223_P(), (Object)false);
            return new Pair((Object)HONEY_CRYSTAL, (Object)true);
        }
        if (block != Blocks.field_196722_fD) return new Pair((Object)Blocks.field_201941_jj.func_176223_P(), (Object)false);
        if (ModChecking.buzzierBeesPresent && Bumblezone.BzConfig.allowScentedCandlesBeeDungeon.get().booleanValue()) {
            if (random.nextFloat() < 0.8f && world.func_180495_p(pos.func_177977_b()).func_185904_a() != Material.field_151579_a) {
                return new Pair((Object)BuzzierBeesRedirection.BBGetRandomTier3Candle(random, Bumblezone.BzConfig.powerfulCandlesRarityBeeDungeon.get() + 1, random.nextInt(random.nextInt(random.nextInt(3) + 1) + 1) + 1, false, true), (Object)true);
            }
            if (!HONEY_CRYSTAL.func_196955_c((IWorldReader)world, pos)) return new Pair((Object)Blocks.field_201941_jj.func_176223_P(), (Object)false);
            return new Pair((Object)HONEY_CRYSTAL, (Object)true);
        }
        if (!(random.nextFloat() < 0.6f) || !HONEY_CRYSTAL.func_196955_c((IWorldReader)world, pos)) return new Pair((Object)Blocks.field_201941_jj.func_176223_P(), (Object)false);
        return new Pair((Object)HONEY_CRYSTAL, (Object)true);
    }
}

