/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.bumblezone.dimension;

import javax.annotation.Nullable;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeDimension;
import net.minecraftforge.fml.common.Mod;
import net.telepathicgrunt.bumblezone.Bumblezone;
import net.telepathicgrunt.bumblezone.generation.BzBiomeProvider;
import net.telepathicgrunt.bumblezone.generation.BzChunkGenerator;

@Mod.EventBusSubscriber(modid="the_bumblezone", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BzDimension
extends Dimension {
    public static boolean ACTIVE_WRATH = false;
    public static float reddishFogTint = 0.0f;

    public BzDimension(World world, DimensionType typeIn) {
        super(world, typeIn, 1.0f);
        for (int i = 0; i <= 15; ++i) {
            this.field_76573_f[i] = (float)i / 20.0f + 0.25f;
        }
    }

    public ChunkGenerator<?> func_186060_c() {
        return new BzChunkGenerator((IWorld)this.field_76579_a, new BzBiomeProvider(this.field_76579_a), (OverworldGenSettings)ChunkGeneratorType.field_206911_b.func_205483_a());
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public MusicTicker.MusicType getMusicType() {
        return null;
    }

    public IForgeDimension.SleepResult canSleepAt(PlayerEntity player, BlockPos pos) {
        return IForgeDimension.SleepResult.DENY;
    }

    public boolean func_76567_e() {
        return false;
    }

    public BlockPos func_206920_a(ChunkPos chunkPosIn, boolean checkValid) {
        return null;
    }

    public BlockPos func_206921_a(int posX, int posZ, boolean checkValid) {
        return null;
    }

    public boolean shouldMapSpin(String entity, double x, double z, double rotation) {
        return true;
    }

    public double getMovementFactor() {
        return Bumblezone.BzConfig.movementFactor.get().intValue();
    }

    public boolean func_177495_o() {
        return false;
    }

    public boolean func_76569_d() {
        return false;
    }

    public int getSeaLevel() {
        return 40;
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        if (Bumblezone.BzConfig.dayNightCycle.get().booleanValue() || Bumblezone.BzConfig.fogBrightnessPercentage.get() > 50.0) {
            return 0.0f;
        }
        return 0.5f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_76561_g() {
        return false;
    }

    public boolean func_191066_m() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_76571_f() {
        return -1.0f;
    }

    public boolean canDoLightning(Chunk chunk) {
        return false;
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return false;
    }

    public float calculateVanillaSkyPositioning(long worldTime, float partialTicks) {
        double fractionComponent = MathHelper.func_181162_h((double)((double)worldTime / 24000.0 - 0.25));
        double d1 = 0.5 - Math.cos(fractionComponent * Math.PI) / 2.0;
        return (float)(fractionComponent * 2.0 + d1) / 3.0f;
    }

    public Vec3d func_76562_b(float celestialAngle, float partialTicks) {
        float colorFactor = 1.0f;
        if (Bumblezone.BzConfig.dayNightCycle.get().booleanValue()) {
            float scaledAngle = Math.abs(0.5f - this.calculateVanillaSkyPositioning(this.getWorld().func_72820_D(), 1.0f)) * 2.0f;
            colorFactor = Math.min(Math.max(scaledAngle * 3.0f - 1.0f, 0.0f), 1.0f);
            colorFactor = (float)((double)colorFactor * (Bumblezone.BzConfig.fogBrightnessPercentage.get() / 100.0));
        } else {
            colorFactor = Bumblezone.BzConfig.fogBrightnessPercentage.get() <= 50.0 ? (float)((double)colorFactor * (Bumblezone.BzConfig.fogBrightnessPercentage.get() / 50.0)) : (float)((double)colorFactor * (Bumblezone.BzConfig.fogBrightnessPercentage.get() / 100.0));
        }
        if (ACTIVE_WRATH && reddishFogTint < 0.25f) {
            reddishFogTint += 0.005f;
        } else if (reddishFogTint > 0.0f) {
            reddishFogTint -= 0.005f;
        }
        return new Vec3d((double)Math.max(Math.min(0.9f * colorFactor, 1.5f) + reddishFogTint, 0.0f), (double)Math.max(Math.min(0.63f * colorFactor, 1.5f) - reddishFogTint, 0.0f), (double)Math.max(Math.min(0.0015f * colorFactor, 1.5f) - reddishFogTint, 0.0f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_76565_k() {
        return 1.0;
    }

    public boolean func_76568_b(int x, int z) {
        return true;
    }
}

