/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.modes;

import com.direwolf20.buildinggadgets.common.building.Region;
import com.direwolf20.buildinggadgets.common.building.placement.ConnectedSurface;
import com.direwolf20.buildinggadgets.common.items.modes.AbstractMode;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;

public class SurfaceMode
extends AbstractMode {
    public SurfaceMode(boolean isExchanging) {
        super(isExchanging);
    }

    @Override
    List<BlockPos> collect(AbstractMode.UseContext context, PlayerEntity player, BlockPos start) {
        int bound = context.getRange() / 2;
        Region area = new Region((Vec3i)start).expand(bound * (1 - Math.abs(context.getHitSide().func_82601_c())), bound * (1 - Math.abs(context.getHitSide().func_96559_d())), bound * (1 - Math.abs(context.getHitSide().func_82599_e())));
        if (!context.isConnected()) {
            return area.stream().map(BlockPos::func_185334_h).collect(Collectors.toList());
        }
        return this.isExchanging() ? ConnectedSurface.create(area, (IBlockReader)context.getWorld(), pos -> pos, start, context.getHitSide().func_176734_d(), context.getRange(), context.isFuzzy()).collect() : ConnectedSurface.create(area, (IBlockReader)context.getWorld(), start, context.getHitSide().func_176734_d(), context.getRange(), context.isFuzzy()).collect();
    }

    @Override
    public boolean validator(PlayerEntity player, BlockPos pos, AbstractMode.UseContext context) {
        boolean topRow = super.validator(player, pos, context);
        if (this.isExchanging()) {
            return topRow;
        }
        BlockState startState = context.getWorldState(context.getStartPos());
        if (context.isFuzzy()) {
            return topRow && !context.getWorld().func_175623_d(pos.func_177972_a(context.getHitSide().func_176734_d()));
        }
        return topRow && context.getWorld().func_180495_p(pos.func_177972_a(context.getHitSide().func_176734_d())) == startState;
    }
}

