/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items;

import com.direwolf20.buildinggadgets.client.renders.BaseRenderer;
import com.direwolf20.buildinggadgets.client.renders.CopyPasteRender;
import com.direwolf20.buildinggadgets.client.screen.GuiMod;
import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.building.BlockData;
import com.direwolf20.buildinggadgets.common.building.Region;
import com.direwolf20.buildinggadgets.common.building.placement.PlacementChecker;
import com.direwolf20.buildinggadgets.common.building.view.IBuildContext;
import com.direwolf20.buildinggadgets.common.building.view.IBuildView;
import com.direwolf20.buildinggadgets.common.building.view.SimpleBuildContext;
import com.direwolf20.buildinggadgets.common.building.view.WorldBuildView;
import com.direwolf20.buildinggadgets.common.capability.CapabilityTemplate;
import com.direwolf20.buildinggadgets.common.capability.provider.TemplateKeyProvider;
import com.direwolf20.buildinggadgets.common.commands.ForceUnloadedCommand;
import com.direwolf20.buildinggadgets.common.commands.OverrideBuildSizeCommand;
import com.direwolf20.buildinggadgets.common.commands.OverrideCopySizeCommand;
import com.direwolf20.buildinggadgets.common.concurrent.CopyScheduler;
import com.direwolf20.buildinggadgets.common.concurrent.PlacementScheduler;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.inventory.IItemIndex;
import com.direwolf20.buildinggadgets.common.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.OurItems;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.packets.PacketBindTool;
import com.direwolf20.buildinggadgets.common.save.SaveManager;
import com.direwolf20.buildinggadgets.common.template.ITemplateKey;
import com.direwolf20.buildinggadgets.common.template.Template;
import com.direwolf20.buildinggadgets.common.template.TemplateHeader;
import com.direwolf20.buildinggadgets.common.util.Additions;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.exceptions.CapabilityNotPresentException;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.direwolf20.buildinggadgets.common.util.lang.ITranslationProvider;
import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.ModeTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.direwolf20.buildinggadgets.common.util.lang.TooltipTranslation;
import com.direwolf20.buildinggadgets.common.util.ref.Reference;
import com.direwolf20.buildinggadgets.common.util.tools.NetworkIO;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.network.PacketDistributor;

public class GadgetCopyPaste
extends AbstractGadget {
    private static final Joiner CHUNK_JOINER = Joiner.on((String)"; ");

    public GadgetCopyPaste() {
        super(OurItems.nonStackableItemProperties().func_200918_c(1), () -> ((ForgeConfigSpec.IntValue)Config.GADGETS.GADGET_COPY_PASTE.undoSize).get(), "buildinggadgets_undo_copy_paste", Reference.BlockReference.TagReference.WHITELIST_COPY_PASTE, Reference.BlockReference.TagReference.BLACKLIST_COPY_PASTE);
    }

    @Override
    public int getEnergyMax() {
        return (Integer)Config.GADGETS.GADGET_COPY_PASTE.maxEnergy.get();
    }

    @Override
    public int getEnergyCost(ItemStack tool) {
        return (Integer)Config.GADGETS.GADGET_COPY_PASTE.energyCost.get();
    }

    @Override
    protected Supplier<BaseRenderer> createRenderFactory() {
        return CopyPasteRender::new;
    }

    @Override
    protected void addCapabilityProviders(ImmutableList.Builder<ICapabilityProvider> providerBuilder, ItemStack stack, @Nullable CompoundNBT tag) {
        super.addCapabilityProviders(providerBuilder, stack, tag);
        providerBuilder.add((Object)new TemplateKeyProvider(stack));
    }

    @Override
    public boolean performRotate(ItemStack stack, PlayerEntity player) {
        return (Boolean)player.field_70170_p.getCapability(CapabilityTemplate.TEMPLATE_PROVIDER_CAPABILITY).map(provider -> (Boolean)stack.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).map(key -> {
            Template template = provider.getTemplateForKey((ITemplateKey)key);
            provider.setTemplate((ITemplateKey)key, template.rotate(Rotation.CLOCKWISE_90));
            provider.requestRemoteUpdate((ITemplateKey)key, PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player));
            return true;
        }).orElse((Object)false)).orElse((Object)false);
    }

    @Override
    public boolean performMirror(ItemStack stack, PlayerEntity player) {
        return (Boolean)player.field_70170_p.getCapability(CapabilityTemplate.TEMPLATE_PROVIDER_CAPABILITY).map(provider -> (Boolean)stack.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).map(key -> {
            Template template = provider.getTemplateForKey((ITemplateKey)key);
            provider.setTemplate((ITemplateKey)key, template.mirror(player.func_174811_aO().func_176740_k()));
            provider.requestRemoteUpdate((ITemplateKey)key, PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player));
            return true;
        }).orElse((Object)false)).orElse((Object)false);
    }

    public static void setRelativeVector(ItemStack stack, BlockPos vec) {
        CompoundNBT nbt = stack.func_196082_o();
        if (vec.equals((Object)BlockPos.field_177992_a)) {
            nbt.func_82580_o("rel_pos");
        } else {
            nbt.func_218657_a("rel_pos", (INBT)NBTUtil.func_186859_a((BlockPos)vec));
        }
    }

    public static BlockPos getRelativeVector(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        return NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("rel_pos"));
    }

    public static int getCopyCounter(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        return nbt.func_74762_e("copy_count");
    }

    public static int getAndIncrementCopyCounter(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        int count = nbt.func_74762_e("copy_count");
        nbt.func_74768_a("copy_count", count + 1);
        return count;
    }

    public static Optional<BlockPos> getActivePos(PlayerEntity playerEntity, ItemStack stack) {
        BlockPos pos = ((AbstractGadget)stack.func_77973_b()).getAnchor(stack);
        if (pos == null) {
            BlockRayTraceResult res = VectorHelper.getLookingAt(playerEntity, stack);
            if (res == null || res.func_216346_c() == RayTraceResult.Type.MISS) {
                return Optional.empty();
            }
            pos = res.func_216350_a().func_177972_a(res.func_216354_b());
        }
        return Optional.of(pos).map(p -> p.func_177971_a((Vec3i)GadgetCopyPaste.getRelativeVector(stack)));
    }

    public static Optional<Region> getSelectedRegion(ItemStack stack) {
        BlockPos lower = GadgetCopyPaste.getLowerRegionBound(stack);
        BlockPos upper = GadgetCopyPaste.getUpperRegionBound(stack);
        if (lower != null && upper != null) {
            return Optional.of(new Region((Vec3i)lower, (Vec3i)upper));
        }
        return Optional.empty();
    }

    public static void setSelectedRegion(ItemStack stack, @Nullable Region region) {
        if (region != null) {
            GadgetCopyPaste.setLowerRegionBound(stack, region.getMin());
            GadgetCopyPaste.setUpperRegionBound(stack, region.getMax());
        } else {
            GadgetCopyPaste.setLowerRegionBound(stack, null);
            GadgetCopyPaste.setUpperRegionBound(stack, null);
        }
    }

    public static void setUpperRegionBound(ItemStack stack, @Nullable BlockPos pos) {
        CompoundNBT nbt = stack.func_196082_o();
        if (pos != null) {
            nbt.func_218657_a("start_pos", (INBT)NBTUtil.func_186859_a((BlockPos)pos));
        } else {
            nbt.func_82580_o("start_pos");
        }
    }

    public static void setLowerRegionBound(ItemStack stack, @Nullable BlockPos pos) {
        CompoundNBT nbt = stack.func_196082_o();
        if (pos != null) {
            nbt.func_218657_a("end_pos", (INBT)NBTUtil.func_186859_a((BlockPos)pos));
        } else {
            nbt.func_82580_o("end_pos");
        }
    }

    @Nullable
    public static BlockPos getUpperRegionBound(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_150297_b("start_pos", 10)) {
            return NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("start_pos"));
        }
        return null;
    }

    @Nullable
    public static BlockPos getLowerRegionBound(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_150297_b("end_pos", 10)) {
            return NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("end_pos"));
        }
        return null;
    }

    private static void setToolMode(ItemStack stack, ToolMode mode) {
        CompoundNBT tagCompound = stack.func_196082_o();
        tagCompound.func_74774_a("mode", mode.getId());
    }

    public static ToolMode getToolMode(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_196082_o();
        ToolMode mode = ToolMode.COPY;
        if (!tagCompound.func_150297_b("mode", 1)) {
            GadgetCopyPaste.setToolMode(stack, mode);
            return mode;
        }
        mode = ToolMode.ofId(tagCompound.func_74771_c("mode"));
        if (mode == null) {
            BuildingGadgets.LOG.debug("Failed to read Tool Mode {} falling back to {}.", (Object)tagCompound.func_74779_i("mode"), (Object)mode);
            mode = ToolMode.COPY;
            GadgetCopyPaste.setToolMode(stack, mode);
        }
        return mode;
    }

    @Override
    protected void onAnchorSet(ItemStack stack, PlayerEntity player, BlockRayTraceResult lookingAt) {
        super.onAnchorSet(stack, player, new BlockRayTraceResult(lookingAt.func_216347_e(), lookingAt.func_216354_b(), lookingAt.func_216350_a().func_177972_a(lookingAt.func_216354_b()), lookingAt.func_216353_d()));
    }

    public static ItemStack getGadget(PlayerEntity player) {
        ItemStack stack = AbstractGadget.getGadget(player);
        if (!(stack.func_77973_b() instanceof GadgetCopyPaste)) {
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        this.addEnergyInformation(tooltip, stack);
        tooltip.add(TooltipTranslation.GADGET_MODE.componentTranslation(GadgetCopyPaste.getToolMode(stack).translation.format(new Object[0])).func_150255_a(Styles.AQUA));
        GadgetCopyPaste.addInformationRayTraceFluid(tooltip, stack);
        GadgetUtils.addTooltipNameAndAuthor(stack, world, tooltip);
    }

    public void setMode(ItemStack heldItem, int modeInt) {
        ToolMode mode = ToolMode.values()[modeInt];
        GadgetCopyPaste.setToolMode(heldItem, mode);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        BlockPos posLookingAt = VectorHelper.getPosLookingAt(player, stack);
        if (!world.func_201670_d()) {
            if (player.func_225608_bj_() && GadgetUtils.setRemoteInventory(stack, player, world, posLookingAt, false) == ActionResultType.SUCCESS) {
                return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
            }
            if (GadgetCopyPaste.getToolMode(stack) == ToolMode.COPY) {
                if (world.func_180495_p(posLookingAt) != Blocks.field_150350_a.func_176223_P()) {
                    this.setRegionAndCopy(stack, world, player, posLookingAt);
                }
            } else if (GadgetCopyPaste.getToolMode(stack) == ToolMode.PASTE && !player.func_225608_bj_()) {
                GadgetCopyPaste.getActivePos(player, stack).ifPresent(pos -> this.build(stack, world, player, (BlockPos)pos));
            }
        } else {
            if (player.func_225608_bj_()) {
                if (Screen.hasControlDown()) {
                    PacketHandler.sendToServer(new PacketBindTool());
                } else if (GadgetUtils.getRemoteInventory(posLookingAt, world, NetworkIO.Operation.EXTRACT) != null) {
                    return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
                }
            }
            if (GadgetCopyPaste.getToolMode(stack) == ToolMode.COPY) {
                if (player.func_225608_bj_() && world.func_180495_p(posLookingAt) == Blocks.field_150350_a.func_176223_P()) {
                    GuiMod.COPY.openScreen(player);
                }
            } else if (player.func_225608_bj_()) {
                GuiMod.PASTE.openScreen(player);
            } else {
                BaseRenderer.updateInventoryCache();
            }
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    private void setRegionAndCopy(ItemStack stack, World world, PlayerEntity player, BlockPos lookedAt) {
        if (player.func_225608_bj_()) {
            if (GadgetCopyPaste.getLowerRegionBound(stack) != null && !this.checkCopy(world, player, new Region((Vec3i)lookedAt, (Vec3i)GadgetCopyPaste.getLowerRegionBound(stack)))) {
                return;
            }
            GadgetCopyPaste.setUpperRegionBound(stack, lookedAt);
        } else {
            if (GadgetCopyPaste.getUpperRegionBound(stack) != null && !this.checkCopy(world, player, new Region((Vec3i)lookedAt, (Vec3i)GadgetCopyPaste.getUpperRegionBound(stack)))) {
                return;
            }
            GadgetCopyPaste.setLowerRegionBound(stack, lookedAt);
        }
        Optional<Region> regionOpt = GadgetCopyPaste.getSelectedRegion(stack);
        if (!regionOpt.isPresent()) {
            player.func_146105_b(MessageTranslation.FIRST_COPY.componentTranslation(new Object[0]).func_150255_a(Styles.DK_GREEN), true);
        }
        regionOpt.ifPresent(region -> this.tryCopy(stack, world, player, (Region)region));
    }

    private void tryCopy(ItemStack stack, World world, PlayerEntity player, Region region) {
        SimpleBuildContext context = SimpleBuildContext.builder().buildingPlayer(player).usedStack(stack).build((IWorld)world);
        WorldBuildView buildView = WorldBuildView.create(context, region, (c, p) -> InventoryHelper.getSafeBlockData(player, p, player.func_184600_cs()));
        this.performCopy(stack, buildView);
    }

    private boolean checkCopy(World world, PlayerEntity player, Region region) {
        ImmutableSortedSet<ChunkPos> unloaded;
        if (!ForceUnloadedCommand.mayForceUnloadedChunks(player) && !(unloaded = region.getUnloadedChunks((IWorldReader)world)).isEmpty()) {
            player.func_146105_b(MessageTranslation.COPY_UNLOADED.componentTranslation(unloaded.size()).func_150255_a(Styles.RED), true);
            BuildingGadgets.LOG.debug("Prevented copy because {} chunks where detected as unloaded.", (Object)unloaded.size());
            BuildingGadgets.LOG.trace("The following chunks were detected as unloaded {}.", (Object)CHUNK_JOINER.join(unloaded));
            return false;
        }
        int maxDimension = (Integer)Config.GADGETS.GADGET_COPY_PASTE.maxCopySize.get();
        if (region.getXSize() > 65535 || region.getYSize() > 255 || region.getZSize() > 65535 || (region.getXSize() > maxDimension || region.getYSize() > maxDimension || region.getZSize() > maxDimension) && !OverrideCopySizeCommand.mayPerformLargeCopy(player)) {
            BlockPos sizeVec = region.getMax().func_177973_b((Vec3i)region.getMin());
            player.func_146105_b(MessageTranslation.COPY_TOO_LARGE.componentTranslation(sizeVec.func_177958_n(), sizeVec.func_177956_o(), sizeVec.func_177952_p(), Math.min(maxDimension, 65535), Math.min(maxDimension, 255), Math.min(maxDimension, 65535)).func_150255_a(Styles.RED), true);
            return false;
        }
        return true;
    }

    private void performCopy(ItemStack stack, WorldBuildView buildView) {
        IBuildContext context = buildView.getContext();
        assert (context.getBuildingPlayer() != null);
        PlayerEntity player = context.getBuildingPlayer();
        CopyScheduler.scheduleCopy((map, region) -> {
            Template newTemplate = new Template((ImmutableMap<BlockPos, BlockData>)map, TemplateHeader.builder(region).name("Copy " + GadgetCopyPaste.getAndIncrementCopyCounter(stack)).author(player.func_200200_C_().func_150261_e()).build());
            this.onCopyFinished(newTemplate.normalize(), stack, player);
        }, buildView, (Integer)Config.GADGETS.GADGET_COPY_PASTE.copySteps.get());
    }

    private void onCopyFinished(Template newTemplate, ItemStack stack, PlayerEntity player) {
        if (!Additions.sizeInvalid(player, newTemplate.getHeader().getBoundingBox())) {
            this.sendMessage(stack, player, MessageTranslation.AREA_COPIED, Styles.DK_GREEN);
        }
        ITemplateKey key = (ITemplateKey)stack.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).orElseThrow(CapabilityNotPresentException::new);
        SaveManager.INSTANCE.getTemplateProvider().setTemplate(key, newTemplate);
        SaveManager.INSTANCE.getTemplateProvider().requestRemoteUpdate(key, (ServerPlayerEntity)player);
    }

    private void build(ItemStack stack, World world, PlayerEntity player, BlockPos pos) {
        world.getCapability(CapabilityTemplate.TEMPLATE_PROVIDER_CAPABILITY).ifPresent(provider -> stack.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).ifPresent(key -> {
            Template template = provider.getTemplateForKey((ITemplateKey)key);
            SimpleBuildContext buildContext = SimpleBuildContext.builder().usedStack(stack).buildingPlayer(player).build((IWorld)world);
            IBuildView view = template.createViewInContext(buildContext);
            view.translateTo(pos);
            if (!this.checkPlacement(world, player, view.getBoundingBox())) {
                return;
            }
            this.schedulePlacement(stack, view, player);
        }));
    }

    private boolean checkPlacement(World world, PlayerEntity player, Region region) {
        ImmutableSortedSet<ChunkPos> unloaded;
        if (!ForceUnloadedCommand.mayForceUnloadedChunks(player) && !(unloaded = region.getUnloadedChunks((IWorldReader)world)).isEmpty()) {
            player.func_146105_b(MessageTranslation.BUILD_UNLOADED.componentTranslation(unloaded.size()).func_150255_a(Styles.RED), true);
            BuildingGadgets.LOG.debug("Prevented build because {} chunks where detected as unloaded.", (Object)unloaded.size());
            BuildingGadgets.LOG.trace("The following chunks were detected as unloaded {}.", (Object)CHUNK_JOINER.join(unloaded));
            return false;
        }
        int maxDimension = (Integer)Config.GADGETS.GADGET_COPY_PASTE.maxBuildSize.get();
        if (!(region.getXSize() <= maxDimension && region.getYSize() <= maxDimension && region.getZSize() <= maxDimension || OverrideBuildSizeCommand.mayPerformLargeBuild(player))) {
            BlockPos sizeVec = region.getMax().func_177973_b((Vec3i)region.getMin());
            player.func_146105_b(MessageTranslation.BUILD_TOO_LARGE.componentTranslation(sizeVec.func_177958_n(), sizeVec.func_177956_o(), sizeVec.func_177952_p(), maxDimension, maxDimension, maxDimension).func_150255_a(Styles.RED), true);
            return false;
        }
        return true;
    }

    private void schedulePlacement(ItemStack stack, IBuildView view, PlayerEntity player) {
        IItemIndex index = InventoryHelper.index(stack, player);
        int energyCost = this.getEnergyCost(stack);
        boolean overwrite = (Boolean)Config.GENERAL.allowOverwriteBlocks.get();
        BlockItemUseContext useContext = new BlockItemUseContext(new ItemUseContext(player, Hand.MAIN_HAND, VectorHelper.getLookingAt(player, stack)));
        PlacementChecker checker = new PlacementChecker((LazyOptional<IEnergyStorage>)stack.getCapability(CapabilityEnergy.ENERGY), t -> energyCost, index, (c, t) -> overwrite ? c.getWorld().func_180495_p(t.getPos()).func_196953_a(useContext) : c.getWorld().func_175623_d(t.getPos()), true);
        PlacementScheduler.schedulePlacement(view, checker, (Integer)Config.GADGETS.placeSteps.get()).withFinisher(p -> {
            this.pushUndo(stack, p.getUndoBuilder().build(view.getContext().getWorld().func_201675_m().func_186058_p()));
            this.onBuildFinished(stack, player, view.getBoundingBox());
        });
    }

    private void onBuildFinished(ItemStack stack, PlayerEntity player, Region bounds) {
        if (!Additions.sizeInvalid(player, bounds)) {
            this.sendMessage(stack, player, MessageTranslation.TEMPLATE_BUILD, Styles.DK_GREEN);
        }
        this.onAnchorRemoved(stack, player);
    }

    private void sendMessage(ItemStack stack, PlayerEntity player, ITranslationProvider messageSource, Style style) {
        player.func_146105_b(messageSource.componentTranslation(new Object[0]).func_150255_a(style), true);
    }

    public static final class ToolMode
    extends Enum<ToolMode> {
        public static final /* enum */ ToolMode COPY = new ToolMode(ModeTranslation.COPY, 0);
        public static final /* enum */ ToolMode PASTE = new ToolMode(ModeTranslation.PASTE, 1);
        public static final ToolMode[] VALUES;
        private static final Byte2ObjectMap<ToolMode> BY_ID;
        private final byte id;
        private final ITranslationProvider translation;
        private static final /* synthetic */ ToolMode[] $VALUES;

        public static ToolMode[] values() {
            return (ToolMode[])$VALUES.clone();
        }

        public static ToolMode valueOf(String name) {
            return Enum.valueOf(ToolMode.class, name);
        }

        private ToolMode(ITranslationProvider translation, int id) {
            this.id = (byte)id;
            this.translation = translation;
        }

        public byte getId() {
            return this.id;
        }

        @Nullable
        public static ToolMode ofId(byte id) {
            return (ToolMode)((Object)BY_ID.get(id));
        }

        public ITranslationProvider getTranslation() {
            return this.translation;
        }

        static {
            $VALUES = new ToolMode[]{COPY, PASTE};
            VALUES = ToolMode.values();
            BY_ID = new Byte2ObjectOpenHashMap();
            for (ToolMode mode : VALUES) {
                assert (!BY_ID.containsKey(mode.getId()));
                BY_ID.put(mode.getId(), (Object)mode);
            }
        }
    }
}

