/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.inventory;

import com.direwolf20.buildinggadgets.common.inventory.IInsertProvider;
import com.direwolf20.buildinggadgets.common.inventory.IItemIndex;
import com.direwolf20.buildinggadgets.common.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.inventory.MatchResult;
import com.direwolf20.buildinggadgets.common.inventory.handle.IObjectHandle;
import com.direwolf20.buildinggadgets.common.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.inventory.materials.objects.IUniqueObject;
import com.direwolf20.buildinggadgets.common.inventory.materials.objects.UniqueItem;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.PeekingIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;

public final class PlayerItemIndex
implements IItemIndex {
    private Map<Class<?>, Map<Object, List<IObjectHandle<?>>>> handleMap;
    private List<IInsertProvider> insertProviders;
    private final ItemStack stack;
    private final PlayerEntity player;

    public PlayerItemIndex(ItemStack stack, PlayerEntity player) {
        this.stack = stack;
        this.player = player;
        this.reIndex();
    }

    @Override
    public Multiset<IUniqueObject<?>> insert(Multiset<IUniqueObject<?>> items, boolean simulate) {
        HashMultiset copy = HashMultiset.create(items);
        HashMultiset toRemove = HashMultiset.create();
        for (Multiset.Entry entry : copy.entrySet()) {
            int remainingCount = this.insertObject((IUniqueObject)entry.getElement(), entry.getCount(), simulate);
            if (remainingCount >= entry.getCount()) continue;
            toRemove.add(entry.getElement(), entry.getCount() - remainingCount);
        }
        Multisets.removeOccurrences((Multiset)copy, (Multiset)toRemove);
        return copy;
    }

    private int insertObject(IUniqueObject<?> obj, int count, boolean simulate) {
        if (obj.preferStackInsert()) {
            return obj.tryCreateInsertStack(Collections.unmodifiableMap(this.handleMap), count).map(itemStack -> this.performSimpleInsert((ItemStack)itemStack, count, simulate)).orElseGet(() -> this.performComplexInsert(obj, count, simulate));
        }
        int remainingCount = this.performComplexInsert(obj, count, simulate);
        return remainingCount == 0 ? 0 : obj.tryCreateInsertStack(Collections.unmodifiableMap(this.handleMap), count).map(itemStack -> this.performSimpleInsert((ItemStack)itemStack, count, simulate)).orElse(remainingCount);
    }

    private int performSimpleInsert(ItemStack stack, int count, boolean simulate) {
        int remainingCount = this.insertIntoProviders(stack, count, simulate);
        if (remainingCount == 0) {
            return 0;
        }
        if (!simulate) {
            this.spawnRemainder(stack, remainingCount);
        }
        return 0;
    }

    private int insertIntoProviders(ItemStack stack, int remainingCount, boolean simulate) {
        for (IInsertProvider insertProvider : this.insertProviders) {
            if ((remainingCount -= insertProvider.insert(stack, remainingCount, simulate)) > 0) continue;
            return 0;
        }
        return remainingCount;
    }

    private int insertIntoEmptyHandles(ItemStack stack, int remainingCount, boolean simulate) {
        List emptyHandles = (List)this.handleMap.computeIfAbsent(Item.class, c -> new HashMap()).getOrDefault(Items.field_190931_a, ImmutableList.of());
        Iterator it = emptyHandles.iterator();
        while (it.hasNext() && remainingCount >= 0) {
            UniqueItem item;
            IObjectHandle handle = (IObjectHandle)it.next();
            int match = handle.insert(item = UniqueItem.ofStack(stack), remainingCount, simulate);
            if (match > 0) {
                remainingCount -= match;
            }
            it.remove();
            this.handleMap.get(Item.class).computeIfAbsent(item.getIndexObject(), i -> new ArrayList()).add(handle);
            if (remainingCount > 0) continue;
            return 0;
        }
        return remainingCount;
    }

    private void spawnRemainder(ItemStack stack, int remainingCount) {
        while (remainingCount > 0) {
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(Math.min(remainingCount, copy.func_77976_d()));
            remainingCount -= copy.func_190916_E();
            ItemEntity itemEntity = new ItemEntity(this.player.field_70170_p, this.player.func_226277_ct_(), this.player.func_226278_cu_(), this.player.func_226281_cx_(), copy);
            this.player.field_70170_p.func_217376_c((Entity)itemEntity);
        }
    }

    private int performComplexInsert(IUniqueObject<?> obj, int count, boolean simulate) {
        int remainingCount = count;
        List handles = (List)((Map)this.handleMap.getOrDefault(obj.getIndexClass(), (Map<Object, List<IObjectHandle<?>>>)ImmutableMap.of())).getOrDefault(obj.getIndexObject(), ImmutableList.of());
        Iterator it = handles.iterator();
        while (it.hasNext() && remainingCount >= 0) {
            IObjectHandle handle = (IObjectHandle)it.next();
            int match = handle.insert(obj, remainingCount, simulate);
            if (match > 0) {
                remainingCount -= match;
            }
            if (handle.shouldCleanup()) {
                it.remove();
            }
            if (remainingCount > 0) continue;
            return 0;
        }
        return remainingCount;
    }

    @Override
    public void reIndex() {
        this.handleMap = InventoryHelper.indexMap(this.stack, this.player);
        this.insertProviders = InventoryHelper.indexInsertProviders(this.stack, this.player);
    }

    @Override
    public MatchResult tryMatch(MaterialList list) {
        MatchResult result = null;
        for (ImmutableMultiset multiset : list) {
            result = this.match(list, (Multiset<IUniqueObject<?>>)multiset, true);
            if (!result.isSuccess()) continue;
            return MatchResult.success(list, result.getFoundItems(), multiset);
        }
        return result == null ? MatchResult.success(list, ImmutableMultiset.of(), ImmutableMultiset.of()) : this.evaluateFailingOptionFoundItems(list);
    }

    private MatchResult evaluateFailingOptionFoundItems(MaterialList list) {
        HashMultiset multiset = HashMultiset.create();
        for (ImmutableMultiset<IUniqueObject<?>> option : list.getItemOptions()) {
            for (Multiset.Entry entry : option.entrySet()) {
                multiset.setCount(entry.getElement(), Math.max(multiset.count(entry.getElement()), entry.getCount()));
            }
        }
        multiset.addAll(list.getRequiredItems());
        MatchResult result = this.match(list, (Multiset<IUniqueObject<?>>)multiset, true);
        if (result.isSuccess()) {
            throw new RuntimeException("This should not be possible! The the content changed between matches?!?");
        }
        PeekingIterator<ImmutableMultiset<IUniqueObject<?>>> it = list.iterator();
        return it.hasNext() ? MatchResult.failure(list, result.getFoundItems(), (ImmutableMultiset)it.next()) : result;
    }

    private MatchResult match(MaterialList list, Multiset<IUniqueObject<?>> multiset, boolean simulate) {
        ImmutableMultiset.Builder availableBuilder = ImmutableMultiset.builder();
        boolean failure = false;
        for (Multiset.Entry entry : multiset.entrySet()) {
            int remainingCount = entry.getCount();
            Class indexClass = ((IUniqueObject)entry.getElement()).getIndexClass();
            List entries = (List)((Map)this.handleMap.getOrDefault(indexClass, (Map<Object, List<IObjectHandle<?>>>)ImmutableMap.of())).getOrDefault(((IUniqueObject)entry.getElement()).getIndexObject(), ImmutableList.of());
            Iterator it = entries.iterator();
            while (it.hasNext() && remainingCount >= 0) {
                IObjectHandle handle = (IObjectHandle)it.next();
                int match = handle.match((IUniqueObject)entry.getElement(), remainingCount, simulate);
                if (match > 0) {
                    remainingCount -= match;
                }
                if (!handle.shouldCleanup()) continue;
                it.remove();
                if (indexClass != Item.class) continue;
                this.handleMap.computeIfAbsent(Item.class, c -> new HashMap()).computeIfAbsent(Items.field_190931_a, i -> new ArrayList()).add(handle);
            }
            if ((remainingCount = Math.max(0, remainingCount)) > 0) {
                failure = true;
            }
            availableBuilder.addCopies(entry.getElement(), entry.getCount() - remainingCount);
        }
        if (failure) {
            return MatchResult.failure(list, availableBuilder.build(), ImmutableMultiset.of());
        }
        return MatchResult.success(list, availableBuilder.build(), ImmutableMultiset.of());
    }

    @Override
    public boolean applyMatch(MatchResult result) {
        if (!result.isSuccess()) {
            return false;
        }
        return this.match(result.getMatchedList(), (Multiset<IUniqueObject<?>>)result.getChosenOption(), false).isSuccess();
    }
}

