/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.entities;

import com.direwolf20.buildinggadgets.common.blocks.ConstructionBlock;
import com.direwolf20.buildinggadgets.common.blocks.ConstructionBlockPowder;
import com.direwolf20.buildinggadgets.common.blocks.OurBlocks;
import com.direwolf20.buildinggadgets.common.building.BlockData;
import com.direwolf20.buildinggadgets.common.entities.EntityBase;
import com.direwolf20.buildinggadgets.common.tileentities.ConstructionBlockTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ObjectHolder;

public class ConstructionBlockEntity
extends EntityBase {
    @ObjectHolder(value="buildinggadgets:construction_block_entity")
    public static EntityType<ConstructionBlockEntity> TYPE;
    private static final DataParameter<BlockPos> FIXED;
    private static final DataParameter<Boolean> MAKING;

    public ConstructionBlockEntity(EntityType<?> type, World world) {
        super(type, world);
    }

    public ConstructionBlockEntity(World world, BlockPos spawnPos, boolean makePaste) {
        this(TYPE, world);
        this.func_70107_b(spawnPos.func_177958_n(), spawnPos.func_177956_o(), spawnPos.func_177952_p());
        this.targetPos = spawnPos;
        this.setMakingPaste(makePaste);
    }

    @Override
    protected int getMaxLife() {
        return 80;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(FIXED, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(MAKING, (Object)false);
    }

    @Override
    protected boolean shouldSetDespawning() {
        if (super.shouldSetDespawning()) {
            return true;
        }
        if (this.targetPos == null) {
            return false;
        }
        Block block = this.field_70170_p.func_180495_p(this.targetPos).func_177230_c();
        return !(block instanceof ConstructionBlock) && !(block instanceof ConstructionBlockPowder);
    }

    @Override
    protected void onSetDespawning() {
        if (this.targetPos != null) {
            if (!this.getMakingPaste()) {
                TileEntity te = this.field_70170_p.func_175625_s(this.targetPos);
                if (te instanceof ConstructionBlockTileEntity) {
                    BlockData tempState = ((ConstructionBlockTileEntity)te).getConstructionBlockData();
                    boolean opaque = tempState.getState().func_200015_d((IBlockReader)this.field_70170_p, this.targetPos);
                    boolean neighborBrightness = false;
                    boolean ambient = false;
                    if (opaque || neighborBrightness || !ambient) {
                        BlockData tempSetBlock = ((ConstructionBlockTileEntity)te).getConstructionBlockData();
                        BlockData tempActualSetBlock = ((ConstructionBlockTileEntity)te).getActualBlockData();
                        this.field_70170_p.func_175656_a(this.targetPos, (BlockState)((BlockState)((BlockState)((Block)OurBlocks.CONSTRUCTION_BLOCK.get()).func_176223_P().func_206870_a(ConstructionBlock.BRIGHT, (Comparable)Boolean.valueOf(!opaque))).func_206870_a(ConstructionBlock.NEIGHBOR_BRIGHTNESS, (Comparable)Boolean.valueOf(neighborBrightness))).func_206870_a(ConstructionBlock.AMBIENT_OCCLUSION, (Comparable)Boolean.valueOf(ambient)));
                        te = this.field_70170_p.func_175625_s(this.targetPos);
                        if (te instanceof ConstructionBlockTileEntity) {
                            ((ConstructionBlockTileEntity)te).setBlockState(tempSetBlock, tempActualSetBlock);
                        }
                    }
                }
            } else if (this.field_70170_p.func_180495_p(this.targetPos) == ((Block)OurBlocks.CONSTRUCTION_POWDER_BLOCK.get()).func_176223_P()) {
                this.field_70170_p.func_175656_a(this.targetPos, ((Block)OurBlocks.CONSTRUCTION_DENSE_BLOCK.get()).func_176223_P());
            }
        }
    }

    public void setMakingPaste(boolean paste) {
        this.field_70180_af.func_187227_b(MAKING, (Object)paste);
    }

    public boolean getMakingPaste() {
        return (Boolean)this.field_70180_af.func_187225_a(MAKING);
    }

    @Override
    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setMakingPaste(compound.func_74767_n("makingPaste"));
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("makingPaste", this.getMakingPaste());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    static {
        FIXED = EntityDataManager.func_187226_a(ConstructionBlockEntity.class, (IDataSerializer)DataSerializers.field_187200_j);
        MAKING = EntityDataManager.func_187226_a(ConstructionBlockEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    }
}

