/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.screen;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.building.PlacementTarget;
import com.direwolf20.buildinggadgets.common.building.view.IBuildView;
import com.direwolf20.buildinggadgets.common.building.view.SimpleBuildContext;
import com.direwolf20.buildinggadgets.common.capability.CapabilityTemplate;
import com.direwolf20.buildinggadgets.common.containers.TemplateManagerContainer;
import com.direwolf20.buildinggadgets.common.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.inventory.MatchResult;
import com.direwolf20.buildinggadgets.common.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.inventory.materials.objects.IUniqueObject;
import com.direwolf20.buildinggadgets.common.items.OurItems;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.packets.PacketTemplateManagerTemplateCreated;
import com.direwolf20.buildinggadgets.common.template.ITemplateKey;
import com.direwolf20.buildinggadgets.common.template.ITemplateProvider;
import com.direwolf20.buildinggadgets.common.template.Template;
import com.direwolf20.buildinggadgets.common.template.TemplateIO;
import com.direwolf20.buildinggadgets.common.tileentities.TemplateManagerTileEntity;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.exceptions.TemplateParseException;
import com.direwolf20.buildinggadgets.common.util.exceptions.TemplateReadException;
import com.direwolf20.buildinggadgets.common.util.exceptions.TemplateWriteException;
import com.direwolf20.buildinggadgets.common.util.lang.GuiTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.awt.Color;
import java.util.Comparator;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public class TemplateManagerGUI
extends ContainerScreen<TemplateManagerContainer> {
    private static final ResourceLocation background = new ResourceLocation("buildinggadgets", "textures/gui/template_manager.png");
    private Rectangle2d panel = new Rectangle2d(-12, 12, 136, 80);
    private boolean panelClicked;
    private int clickButton;
    private int clickX;
    private int clickY;
    private float initRotX;
    private float initRotY;
    private float initZoom;
    private float initPanX;
    private float initPanY;
    private float momentumX;
    private float momentumY;
    private float rotX = 0.0f;
    private float rotY = 0.0f;
    private float zoom = 1.0f;
    private float panX = 0.0f;
    private float panY = 0.0f;
    private TextFieldWidget nameField;
    private Button buttonSave;
    private Button buttonLoad;
    private Button buttonCopy;
    private Button buttonPaste;
    private TemplateManagerTileEntity te;
    private TemplateManagerContainer container;
    private LazyOptional<ITemplateProvider> templateProvider = this.getWorld().getCapability(CapabilityTemplate.TEMPLATE_PROVIDER_CAPABILITY);
    private Template template;

    public TemplateManagerGUI(TemplateManagerContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, (ITextComponent)new StringTextComponent(""));
        this.container = container;
        this.te = container.getTe();
    }

    public void init() {
        super.init();
        this.font.getClass();
        this.nameField = new TextFieldWidget(this.font, this.field_147003_i - 20 + 8, this.field_147009_r - 5, this.field_146999_f - 16, 9 + 3, GuiTranslation.TEMPLATE_NAME_TIP.format(new Object[0]));
        int x = this.field_147003_i - 20 + 180;
        this.buttonSave = (Button)this.addButton((Widget)new Button(x, this.field_147009_r + 17, 60, 20, GuiTranslation.BUTTON_SAVE.format(new Object[0]), b -> this.onSave()));
        this.buttonLoad = (Button)this.addButton((Widget)new Button(x, this.field_147009_r + 39, 60, 20, GuiTranslation.BUTTON_LOAD.format(new Object[0]), b -> this.onLoad()));
        this.buttonCopy = (Button)this.addButton((Widget)new Button(x, this.field_147009_r + 66, 60, 20, GuiTranslation.BUTTON_COPY.format(new Object[0]), b -> this.onCopy()));
        this.buttonPaste = (Button)this.addButton((Widget)new Button(x, this.field_147009_r + 89, 60, 20, GuiTranslation.BUTTON_PASTE.format(new Object[0]), b -> this.onPaste()));
        this.nameField.func_146203_f(50);
        this.nameField.func_146189_e(true);
        this.children.add(this.nameField);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        if (this.template != null) {
            this.renderRequirement(mouseX, mouseY);
        }
        this.validateCache(partialTicks);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.renderBackground();
        this.getMinecraft().func_110434_K().func_110577_a(background);
        this.blit(this.field_147003_i - 20, this.field_147009_r - 12, 0, 0, this.field_146999_f, this.field_147000_g + 25);
        this.blit(this.field_147003_i - 20 + this.field_146999_f, this.field_147009_r + 8, this.field_146999_f + 3, 30, 71, this.field_147000_g);
        if (!this.buttonCopy.isHovered() && !this.buttonPaste.isHovered()) {
            if (this.buttonLoad.isHovered()) {
                this.blit(this.field_147003_i + this.field_146999_f - 44, this.field_147009_r + 38, this.field_146999_f, 0, 17, 24);
            } else {
                this.blit(this.field_147003_i + this.field_146999_f - 44, this.field_147009_r + 38, this.field_146999_f + 17, 0, 16, 24);
            }
        }
        this.nameField.render(mouseX, mouseY, partialTicks);
        TemplateManagerGUI.fill((int)(this.field_147003_i + this.panel.func_199318_a() - 1), (int)(this.field_147009_r + this.panel.func_199319_b() - 1), (int)(this.field_147003_i + this.panel.func_199318_a() + this.panel.func_199316_c() + 1), (int)(this.field_147009_r + this.panel.func_199319_b() + this.panel.func_199317_d() + 1), (int)-7697782);
        if (this.template != null) {
            this.renderPanel();
        }
    }

    private void validateCache(float partialTicks) {
        if (this.container.func_75139_a(0).func_75211_c().func_190926_b() && this.template != null) {
            this.template = null;
            this.resetViewport();
            return;
        }
        this.container.func_75139_a(0).func_75211_c().getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).ifPresent(key -> this.templateProvider.ifPresent(provider -> {
            Template template = provider.getTemplateForKey((ITemplateKey)key);
            if (this.template == template) {
                return;
            }
            this.template = template;
        }));
    }

    private void renderStructure(IBuildView view, float partialTicks) {
        Random rand = new Random();
        BlockRendererDispatcher dispatcher = this.getMinecraft().func_175602_ab();
        BufferBuilder bufferBuilder = new BufferBuilder(0x200000);
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        for (PlacementTarget target : view) {
            target.placeIn(view.getContext());
            BlockPos targetPos = target.getPos();
            BlockState renderBlockState = view.getContext().getWorld().func_180495_p(targetPos);
            TileEntity te = view.getContext().getWorld().func_175625_s(targetPos);
            if (renderBlockState.func_185901_i() == BlockRenderType.MODEL) {
                IBakedModel iBakedModel = dispatcher.func_184389_a(renderBlockState);
            }
            if (te == null) continue;
            try {
                TileEntityRenderer renderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(te);
                if (renderer != null) {
                    // empty if block
                }
                this.getMinecraft().func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
            }
            catch (Exception e) {
                BuildingGadgets.LOG.error("Error rendering TileEntity", (Throwable)e);
            }
        }
        bufferBuilder.func_178977_d();
    }

    private void renderRequirement(int mouseX, int mouseY) {
        MaterialList requirements = this.template.getHeaderAndForceMaterials(SimpleBuildContext.builder().build((IWorld)this.getWorld())).getRequiredItems();
        if (requirements == null) {
            return;
        }
        RenderHelper.func_227780_a_();
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)(this.field_147003_i - 30), (double)(this.field_147009_r - 5), (double)200.0);
        RenderSystem.scalef((float)0.8f, (float)0.8f, (float)0.8f);
        this.drawRightAlignedString(this.getMinecraft().field_71466_p, "Requirements", 5, 0, Color.WHITE.getRGB());
        MatchResult list = InventoryHelper.CREATIVE_INDEX.tryMatch(requirements);
        ImmutableMultiset<IUniqueObject<?>> foundItems = list.getFoundItems();
        ImmutableList sortedEntries = ImmutableList.sortedCopyOf(Comparator.comparing(Multiset.Entry::getCount).reversed(), (Iterable)list.getChosenOption().entrySet());
        int index = 0;
        int column = 0;
        for (Multiset.Entry e : sortedEntries) {
            ItemStack stack = ((IUniqueObject)e.getElement()).createStack();
            int x = -20 - column * 25;
            int y = 20 + index * 25;
            this.itemRenderer.func_184391_a((LivingEntity)this.minecraft.field_71439_g, stack, x + 4, y + 4);
            this.itemRenderer.func_180453_a(Minecraft.func_71410_x().field_71466_p, stack, x + 4, y + 4, GadgetUtils.withSuffix(foundItems.count(e.getElement())));
            int space = 20;
            int zoneX = this.field_147003_i - 32 + (-15 - column * space);
            int zoneY = this.field_147009_r - 9 + (20 + index * space);
            if (mouseX > zoneX && mouseX < zoneX + space && mouseY > zoneY && mouseY < zoneY + space) {
                this.renderTooltip(stack.func_82840_a((PlayerEntity)this.minecraft.field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL).stream().map(ITextComponent::func_150254_d).collect(Collectors.toList()), x + 15, y + 25);
            }
            if (++index % 8 != 0) continue;
            ++column;
            index = 0;
        }
        RenderHelper.func_74518_a();
        RenderSystem.popMatrix();
    }

    private void pasteTemplateToStack(World world, ItemStack stack, Template newTemplate, boolean replaced) {
        world.getCapability(CapabilityTemplate.TEMPLATE_PROVIDER_CAPABILITY).ifPresent(provider -> this.pasteTemplateToStack((ITemplateProvider)provider, stack, newTemplate, replaced && world.func_201670_d()));
    }

    private void pasteTemplateToStack(ITemplateProvider provider, ItemStack stack, Template newTemplate, boolean replaced) {
        stack.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).ifPresent(key -> {
            provider.setTemplate((ITemplateKey)key, newTemplate);
            if (replaced) {
                PacketHandler.sendToServer(new PacketTemplateManagerTemplateCreated(provider.getId((ITemplateKey)key), this.te.func_174877_v()));
            } else {
                provider.requestRemoteUpdate((ITemplateKey)key);
            }
        });
    }

    private boolean replaceStack() {
        ItemStack stack = this.container.func_75139_a(1).func_75211_c();
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).isPresent()) {
            return false;
        }
        if (TemplateManagerTileEntity.TEMPLATE_CONVERTIBLES.func_199685_a_((Object)stack.func_77973_b())) {
            this.container.func_75141_a(1, new ItemStack((IItemProvider)OurItems.TEMPLATE_ITEM.get()));
            return true;
        }
        return false;
    }

    private void rename(ItemStack stack) {
        if (this.nameField.func_146179_b().isEmpty()) {
            return;
        }
        stack.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).ifPresent(key -> this.templateProvider.ifPresent(provider -> {
            Template template = provider.getTemplateForKey((ITemplateKey)key);
            template = template.withName(this.nameField.func_146179_b());
            provider.setTemplate((ITemplateKey)key, template);
            provider.requestRemoteUpdate((ITemplateKey)key);
        }));
    }

    private void renderPanel() {
        double scale = this.getMinecraft().func_228018_at_().func_198100_s();
        BlockPos startPos = this.template.getHeader().getBoundingBox().getMin();
        BlockPos endPos = this.template.getHeader().getBoundingBox().getMax();
        double lengthX = Math.abs(startPos.func_177958_n() - endPos.func_177958_n());
        double lengthY = Math.abs(startPos.func_177956_o() - endPos.func_177956_o());
        double lengthZ = Math.abs(startPos.func_177952_p() - endPos.func_177952_p());
        double maxW = 96.0;
        double maxH = 176.0;
        double overW = Math.max(lengthX * 16.0 - 96.0, lengthZ * 16.0 - 96.0);
        double overH = lengthY * 16.0 - 176.0;
        double sc = 1.0;
        double zoomScale = 1.0;
        if (overW > 0.0 && overW >= overH) {
            sc = 96.0 / (overW + 96.0);
            zoomScale = overW / 40.0;
        } else if (overH > 0.0 && overH >= overW) {
            sc = 176.0 / (overH + 176.0);
            zoomScale = overH / 40.0;
        }
        RenderSystem.pushMatrix();
        RenderSystem.matrixMode((int)5889);
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        RenderSystem.multMatrix((Matrix4f)Matrix4f.func_195876_a((double)60.0, (float)((float)this.panel.func_199316_c() / (float)this.panel.func_199317_d()), (float)0.01f, (float)4000.0f));
        RenderSystem.matrixMode((int)5888);
        RenderSystem.viewport((int)((int)Math.round((double)(this.field_147003_i + this.panel.func_199318_a()) * scale)), (int)((int)Math.round((double)this.getMinecraft().func_228018_at_().func_198091_l() - (double)(this.field_147009_r + this.panel.func_199319_b() + this.panel.func_199317_d()) * scale)), (int)((int)Math.round((double)this.panel.func_199316_c() * scale)), (int)((int)Math.round((double)this.panel.func_199317_d() * scale)));
        RenderSystem.clear((int)256, (boolean)true);
        sc = 293.0 * sc + (double)this.zoom / zoomScale;
        RenderSystem.scaled((double)sc, (double)sc, (double)sc);
        int moveX = startPos.func_177958_n() - endPos.func_177958_n();
        RenderSystem.rotatef((float)30.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        if (startPos.func_177958_n() >= endPos.func_177958_n()) {
            --moveX;
        }
        RenderSystem.translated((double)((double)moveX / 1.75), (double)((double)(-Math.abs(startPos.func_177956_o() - endPos.func_177956_o())) / 1.75), (double)0.0);
        RenderSystem.translated((double)this.panX, (double)(-this.panY), (double)0.0);
        RenderSystem.translated((double)((float)(startPos.func_177958_n() - endPos.func_177958_n()) / 2.0f * -1.0f), (double)((float)(startPos.func_177956_o() - endPos.func_177956_o()) / 2.0f * -1.0f), (double)((float)(startPos.func_177952_p() - endPos.func_177952_p()) / 2.0f * -1.0f));
        RenderSystem.rotatef((float)(-this.rotX), (float)1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.rotatef((float)this.rotY, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.translated((double)((float)(startPos.func_177958_n() - endPos.func_177958_n()) / 2.0f), (double)((float)(startPos.func_177956_o() - endPos.func_177956_o()) / 2.0f), (double)((float)(startPos.func_177952_p() - endPos.func_177952_p()) / 2.0f));
        this.getMinecraft().func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
        RenderSystem.popMatrix();
        RenderSystem.matrixMode((int)5889);
        RenderSystem.popMatrix();
        RenderSystem.matrixMode((int)5888);
        RenderSystem.viewport((int)0, (int)0, (int)this.getMinecraft().func_228018_at_().func_198109_k(), (int)this.getMinecraft().func_228018_at_().func_198091_l());
    }

    private void resetViewport() {
        this.rotX = 0.0f;
        this.rotY = 0.0f;
        this.zoom = 1.0f;
        this.momentumX = 0.0f;
        this.momentumY = 0.0f;
        this.panX = 0.0f;
        this.panY = 0.0f;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.panel.func_199315_b((int)mouseX - this.field_147003_i, (int)mouseY - this.field_147009_r)) {
            this.clickButton = mouseButton;
            this.panelClicked = true;
            this.clickX = (int)this.getMinecraft().field_71417_B.func_198024_e();
            this.clickY = (int)this.getMinecraft().field_71417_B.func_198026_f();
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int state) {
        this.panelClicked = false;
        this.initRotX = this.rotX;
        this.initRotY = this.rotY;
        this.initPanX = this.panX;
        this.initPanY = this.panY;
        this.initZoom = this.zoom;
        return super.mouseReleased(mouseX, mouseY, state);
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            this.onClose();
            return true;
        }
        return this.nameField.isFocused() ? this.nameField.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) : super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    protected void func_146979_b(int j, int i) {
        if (this.panelClicked) {
            if (this.clickButton == 0) {
                float prevRotX = this.rotX;
                float prevRotY = this.rotY;
                this.rotX = this.initRotX - (float)((int)this.getMinecraft().field_71417_B.func_198026_f() - this.clickY);
                this.rotY = this.initRotY + (float)((int)this.getMinecraft().field_71417_B.func_198024_e() - this.clickX);
                this.momentumX = this.rotX - prevRotX;
                this.momentumY = this.rotY - prevRotY;
            } else if (this.clickButton == 1) {
                this.panX = this.initPanX + (float)((int)this.getMinecraft().field_71417_B.func_198024_e() - this.clickX) / 8.0f;
                this.panY = this.initPanY + (float)((int)this.getMinecraft().field_71417_B.func_198026_f() - this.clickY) / 8.0f;
            }
        }
        this.rotX += this.momentumX;
        this.rotY += this.momentumY;
        float momentumDampening = 0.98f;
        this.momentumX *= momentumDampening;
        this.momentumY *= momentumDampening;
        if (!this.nameField.isFocused() && this.nameField.func_146179_b().isEmpty()) {
            this.getMinecraft().field_71466_p.func_211126_b(GuiTranslation.TEMPLATE_PLACEHOLDER.format(new Object[0]), (float)(this.nameField.x - this.field_147003_i + 4), (float)(this.nameField.y + 2 - this.field_147009_r), -10197916);
        }
        if (this.buttonSave.isHovered() || this.buttonLoad.isHovered() || this.buttonPaste.isHovered()) {
            this.drawSlotOverlay(this.buttonLoad.isHovered() ? this.container.func_75139_a(0) : this.container.func_75139_a(1));
        }
    }

    private void drawSlotOverlay(Slot slot) {
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)0.0, (double)0.0, (double)1000.0);
        TemplateManagerGUI.fill((int)slot.field_75223_e, (int)slot.field_75221_f, (int)(slot.field_75223_e + 16), (int)(slot.field_75221_f + 16), (int)-1660903937);
        RenderSystem.translated((double)0.0, (double)0.0, (double)-1000.0);
        RenderSystem.popMatrix();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollDelta) {
        this.zoom = this.initZoom + (float)scrollDelta * 20.0f;
        if (this.zoom < -200.0f) {
            this.zoom = -200.0f;
        }
        if (this.zoom > 5000.0f) {
            this.zoom = 5000.0f;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollDelta);
    }

    public void tick() {
        super.tick();
        this.nameField.func_146178_a();
        if (!this.panelClicked) {
            this.initRotX = this.rotX;
            this.initRotY = this.rotY;
            this.initZoom = this.zoom;
            this.initPanX = this.panX;
            this.initPanY = this.panY;
        }
    }

    private World getWorld() {
        return this.getMinecraft().field_71441_e;
    }

    public Minecraft getMinecraft() {
        return Minecraft.func_71410_x();
    }

    private void runAfterUpdate(int slot, Runnable runnable) {
        this.container.func_75139_a(slot).func_75211_c().getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).ifPresent(key -> this.templateProvider.ifPresent(provider -> {
            provider.registerUpdateListener(new ITemplateProvider.IUpdateListener((ITemplateKey)key, runnable){
                final /* synthetic */ ITemplateKey val$key;
                final /* synthetic */ Runnable val$runnable;
                {
                    this.val$key = iTemplateKey;
                    this.val$runnable = runnable;
                }

                @Override
                public void onTemplateUpdate(ITemplateProvider provider, ITemplateKey updateKey, Template template) {
                    if (provider.getId(updateKey).equals(provider.getId(this.val$key))) {
                        this.val$runnable.run();
                        provider.removeUpdateListener(this);
                    }
                }
            });
            provider.requestUpdate((ITemplateKey)key);
        }));
    }

    private void onSave() {
        boolean replaced = this.replaceStack();
        ItemStack left = this.container.func_75139_a(0).func_75211_c();
        ItemStack right = this.container.func_75139_a(1).func_75211_c();
        if (left.func_190926_b()) {
            this.rename(right);
            return;
        }
        this.runAfterUpdate(0, () -> this.templateProvider.ifPresent(provider -> left.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).ifPresent(key -> {
            Template templateToSave = provider.getTemplateForKey((ITemplateKey)key);
            this.pasteTemplateToStack((ITemplateProvider)provider, right, templateToSave, replaced);
        })));
    }

    private void onLoad() {
        boolean replaced = this.replaceStack();
        ItemStack left = this.container.func_75139_a(0).func_75211_c();
        ItemStack right = this.container.func_75139_a(1).func_75211_c();
        if (left.func_190926_b()) {
            this.rename(right);
            return;
        }
        this.runAfterUpdate(1, () -> this.templateProvider.ifPresent(provider -> right.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).ifPresent(key -> {
            Template templateToSave = provider.getTemplateForKey((ITemplateKey)key);
            this.pasteTemplateToStack((ITemplateProvider)provider, left, templateToSave, replaced);
        })));
    }

    private void onCopy() {
        this.runAfterUpdate(0, () -> {
            ItemStack stack = this.container.func_75139_a(0).func_75211_c();
            stack.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).ifPresent(key -> this.templateProvider.ifPresent(provider -> {
                ClientPlayerEntity player = this.getMinecraft().field_71439_g;
                assert (player != null);
                SimpleBuildContext buildContext = SimpleBuildContext.builder().buildingPlayer((PlayerEntity)player).usedStack(stack).build((IWorld)this.getWorld());
                try {
                    Template template = provider.getTemplateForKey((ITemplateKey)key);
                    if (!this.nameField.func_146179_b().isEmpty()) {
                        template = template.withName(this.nameField.func_146179_b());
                    }
                    String json = TemplateIO.writeTemplateJson(template, buildContext);
                    this.getMinecraft().field_195559_v.func_197960_a(json);
                    player.func_146105_b(MessageTranslation.CLIPBOARD_COPY_SUCCESS.componentTranslation(new Object[0]).func_150255_a(Styles.DK_GREEN), false);
                }
                catch (TemplateWriteException.DataCannotBeWrittenException e) {
                    BuildingGadgets.LOG.error("Failed to write Template.", (Throwable)e);
                    player.func_146105_b(MessageTranslation.CLIPBOARD_COPY_ERROR_TEMPLATE.componentTranslation(new Object[0]).func_150255_a(Styles.RED), false);
                }
                catch (Exception e) {
                    BuildingGadgets.LOG.error("Failed to copy Template to clipboard.", (Throwable)e);
                    player.func_146105_b(MessageTranslation.CLIPBOARD_COPY_ERROR.componentTranslation(new Object[0]).func_150255_a(Styles.RED), false);
                }
            }));
        });
    }

    private void onPaste() {
        assert (this.getMinecraft().field_71439_g != null);
        String CBString = this.getMinecraft().field_195559_v.func_197965_a();
        if (GadgetUtils.mightBeLink(CBString)) {
            this.getMinecraft().field_71439_g.func_146105_b(MessageTranslation.PASTE_SUCCESS.componentTranslation(new Object[0]).func_150255_a(Styles.RED), false);
            return;
        }
        try {
            JsonToNBT.func_180713_a((String)CBString);
            BuildingGadgets.LOG.error("Attempted to use a 1.12 compound on a newer MC version");
            this.getMinecraft().field_71439_g.func_146105_b(MessageTranslation.PASTE_FAILED_WRONG_MC_VERSION.componentTranslation("(1.12.x)", Minecraft.func_71410_x().func_213229_ar().getVersion().getName()).func_150255_a(Styles.RED), false);
            return;
        }
        catch (CommandSyntaxException commandSyntaxException) {
            try {
                Template readTemplate = TemplateIO.readTemplateFromJson(CBString).clearMaterials();
                if (!this.nameField.func_146179_b().isEmpty()) {
                    readTemplate = readTemplate.withName(this.nameField.func_146179_b());
                }
                boolean replaced = this.replaceStack();
                ItemStack stack = this.container.func_75139_a(1).func_75211_c();
                this.pasteTemplateToStack(this.getWorld(), stack, readTemplate, replaced);
                this.getMinecraft().field_71439_g.func_146105_b(MessageTranslation.PASTE_SUCCESS.componentTranslation(new Object[0]).func_150255_a(Styles.DK_GREEN), false);
            }
            catch (TemplateReadException.CorruptJsonException e) {
                BuildingGadgets.LOG.error("Failed to parse json syntax.", (Throwable)e);
                this.getMinecraft().field_71439_g.func_146105_b(MessageTranslation.PASTE_FAILED_CORRUPT_JSON.componentTranslation(new Object[0]).func_150255_a(Styles.RED), false);
            }
            catch (TemplateParseException.IllegalMinecraftVersionException e) {
                BuildingGadgets.LOG.error("Attempted to parse Template for Minecraft version {} but expected {}.", (Object)e.getMinecraftVersion(), (Object)e.getExpectedVersion(), (Object)e);
                this.getMinecraft().field_71439_g.func_146105_b(MessageTranslation.PASTE_FAILED_WRONG_MC_VERSION.componentTranslation(e.getMinecraftVersion(), e.getExpectedVersion()).func_150255_a(Styles.RED), false);
            }
            catch (TemplateParseException.UnknownTemplateVersionException e) {
                BuildingGadgets.LOG.error("Attempted to parse Template version {} but newest is {}.", (Object)e.getTemplateVersion(), (Object)"2-beta", (Object)e);
                this.getMinecraft().field_71439_g.func_146105_b(MessageTranslation.PASTE_FAILED_TOO_RECENT_VERSION.componentTranslation(e.getTemplateVersion(), "2-beta").func_150255_a(Styles.RED), false);
            }
            catch (JsonParseException e) {
                BuildingGadgets.LOG.error("Failed to parse Template json.", (Throwable)e);
                this.getMinecraft().field_71439_g.func_146105_b(MessageTranslation.PASTE_FAILED_INVALID_JSON.componentTranslation(new Object[0]).func_150255_a(Styles.RED), false);
            }
            catch (TemplateReadException e) {
                BuildingGadgets.LOG.error("Failed to read Template body.", (Throwable)e);
                this.getMinecraft().field_71439_g.func_146105_b(MessageTranslation.PASTE_FAILED_CORRUPT_BODY.componentTranslation(new Object[0]).func_150255_a(Styles.RED), false);
            }
            catch (Exception e) {
                BuildingGadgets.LOG.error("Failed to paste Template.", (Throwable)e);
                this.getMinecraft().field_71439_g.func_146105_b(MessageTranslation.PASTE_FAILED.componentTranslation(new Object[0]).func_150255_a(Styles.RED), false);
            }
            return;
        }
    }
}

