/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.screen;

import com.direwolf20.buildinggadgets.client.screen.MaterialListGUI;
import com.direwolf20.buildinggadgets.client.screen.components.EntryList;
import com.direwolf20.buildinggadgets.common.inventory.IItemIndex;
import com.direwolf20.buildinggadgets.common.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.inventory.MatchResult;
import com.direwolf20.buildinggadgets.common.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.inventory.materials.objects.IUniqueObject;
import com.direwolf20.buildinggadgets.common.util.lang.ITranslationProvider;
import com.direwolf20.buildinggadgets.common.util.lang.MaterialListTranslation;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multiset;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.Comparator;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

class ScrollingMaterialList
extends EntryList<Entry> {
    private static final int UPDATE_MILLIS = 1000;
    static final int TOP = 16;
    static final int BOTTOM = 32;
    private static final int SLOT_SIZE = 18;
    private static final int MARGIN = 2;
    private static final int ENTRY_HEIGHT;
    private static final int LINE_SIDE_MARGIN = 8;
    private MaterialListGUI gui;
    private SortingModes sortingMode;
    private long lastUpdate;
    private Iterator<ImmutableMultiset<IUniqueObject<?>>> multisetIterator;

    public ScrollingMaterialList(MaterialListGUI gui) {
        super(gui.getWindowLeftX(), gui.getWindowTopY() + 16, gui.getWindowWidth(), gui.getWindowHeight() - 16 - 32, ENTRY_HEIGHT);
        this.gui = gui;
        this.setSortingMode(SortingModes.NAME);
        this.updateEntries();
    }

    private void updateEntries() {
        ClientPlayerEntity player;
        this.lastUpdate = System.currentTimeMillis();
        this.clearEntries();
        if (this.multisetIterator == null || !this.multisetIterator.hasNext()) {
            MaterialList list = this.gui.getHeader().getRequiredItems();
            UnmodifiableIterator unmodifiableIterator = this.multisetIterator = list != null ? list.iterator() : Iterators.singletonIterator((Object)ImmutableMultiset.of());
        }
        if ((player = Minecraft.func_71410_x().field_71439_g) == null) {
            return;
        }
        IItemIndex index = InventoryHelper.index(this.gui.getTemplateItem(), (PlayerEntity)player);
        MatchResult result = index.tryMatch((Multiset)this.multisetIterator.next());
        for (Multiset.Entry entry : result.getChosenOption().entrySet()) {
            IUniqueObject item = (IUniqueObject)entry.getElement();
            this.addEntry((AbstractList.AbstractListEntry)new Entry(this, item, entry.getCount(), result.getFoundItems().count(entry.getElement())));
        }
        this.sort();
    }

    protected int getScrollbarPosition() {
        return this.getRight() - 2 - 6;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 69) {
            assert (this.minecraft.field_71439_g != null);
            this.minecraft.field_71439_g.func_71053_j();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.lastUpdate + 1000L < System.currentTimeMillis()) {
            this.updateEntries();
        }
        super.render(mouseX, mouseY, partialTicks);
    }

    public void reset() {
        this.multisetIterator = null;
    }

    public SortingModes getSortingMode() {
        return this.sortingMode;
    }

    public void setSortingMode(SortingModes sortingMode) {
        this.sortingMode = sortingMode;
        this.sort();
    }

    private void sort() {
        this.children().sort(this.sortingMode.getComparator());
    }

    static {
        Minecraft.func_71410_x().field_71466_p.getClass();
        ENTRY_HEIGHT = Math.max(22, 9 * 2 + 6);
    }

    static enum SortingModes {
        NAME(Comparator.comparing(Entry::getItemName), MaterialListTranslation.BUTTON_SORTING_NAMEAZ),
        NAME_REVERSED(NAME.getComparator().reversed(), MaterialListTranslation.BUTTON_SORTING_NAMEZA),
        REQUIRED(Comparator.comparingInt(Entry::getRequired), MaterialListTranslation.BUTTON_SORTING_REQUIREDACSE),
        REQUIRED_REVERSED(REQUIRED.getComparator().reversed(), MaterialListTranslation.BUTTON_SORTING_MISSINGDESC),
        MISSING(Comparator.comparingInt(Entry::getMissing), MaterialListTranslation.BUTTON_SORTING_MISSINGACSE),
        MISSING_REVERSED(MISSING.getComparator().reversed(), MaterialListTranslation.BUTTON_SORTING_MISSINGDESC);

        private final Comparator<Entry> comparator;
        private final ITranslationProvider translationProvider;
        public static final SortingModes[] VALUES;

        private SortingModes(Comparator<Entry> comparator, ITranslationProvider provider) {
            this.comparator = comparator;
            this.translationProvider = provider;
        }

        public Comparator<Entry> getComparator() {
            return this.comparator;
        }

        public String getLocalizedName() {
            return this.translationProvider.format(new Object[0]);
        }

        public SortingModes next() {
            int nextIndex = this.ordinal() + 1;
            return VALUES[nextIndex >= VALUES.length ? 0 : nextIndex];
        }

        static {
            VALUES = SortingModes.values();
        }
    }

    static class Entry
    extends ExtendedList.AbstractListEntry<Entry> {
        private ScrollingMaterialList parent;
        private int required;
        private int available;
        private ItemStack stack;
        private String itemName;
        private String amount;
        private int widthItemName;
        private int widthAmount;

        public Entry(ScrollingMaterialList parent, IUniqueObject<?> item, int required, int available) {
            this.parent = parent;
            this.required = required;
            this.available = MathHelper.func_76125_a((int)available, (int)0, (int)required);
            this.stack = item.createStack();
            this.itemName = this.stack.func_200301_q().getString();
            this.amount = this.available + "/" + required;
            this.widthItemName = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.itemName);
            this.widthAmount = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.amount);
        }

        public void render(int index, int topY, int leftX, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float particleTicks) {
            int right = leftX + entryWidth - 4;
            int bottom = topY + entryHeight;
            int slotX = leftX + 2;
            int slotY = topY + 2;
            this.drawIcon(this.stack, slotX, slotY);
            this.drawTextOverlay(right, topY, bottom, slotX);
            this.drawHoveringText(this.stack, slotX, slotY, mouseX, mouseY);
        }

        private void drawTextOverlay(int right, int top, int bottom, int slotX) {
            int itemNameX = slotX + 18 + 2;
            MaterialListGUI.renderTextVerticalCenter(this.itemName, itemNameX, top, bottom, Color.WHITE.getRGB());
            Minecraft.func_71410_x().field_71466_p.getClass();
            MaterialListGUI.renderTextHorizontalRight(this.amount, right, MaterialListGUI.getYForAlignedCenter(top, bottom, 9), this.getTextColor());
            this.drawGuidingLine(right, top, bottom, itemNameX, this.widthItemName, this.widthAmount);
        }

        private void drawGuidingLine(int right, int top, int bottom, int itemNameX, int widthItemName, int widthAmount) {
            if (!this.isSelected()) {
                int lineXStart = itemNameX + widthItemName + 8;
                int lineXEnd = right - widthAmount - 8;
                int lineY = MaterialListGUI.getYForAlignedCenter(top, bottom - 1, 1);
                RenderSystem.enableBlend();
                RenderSystem.disableTexture();
                RenderSystem.blendFunc((int)770, (int)771);
                RenderSystem.color4f((float)255.0f, (float)255.0f, (float)255.0f, (float)34.0f);
                GL11.glLineWidth((float)1.0f);
                GL11.glBegin((int)1);
                GL11.glVertex3f((float)lineXStart, (float)lineY, (float)0.0f);
                GL11.glVertex3f((float)lineXEnd, (float)lineY, (float)0.0f);
                GL11.glEnd();
                RenderSystem.enableTexture();
            }
        }

        private void drawHoveringText(ItemStack item, int slotX, int slotY, int mouseX, int mouseY) {
            if (MaterialListGUI.isPointInBox(mouseX, mouseY, slotX, slotY, 18, 18)) {
                this.parent.gui.setTaskHoveringText(mouseX, mouseY, this.parent.gui.getTooltipFromItem(item));
            }
        }

        private void drawIcon(ItemStack item, int slotX, int slotY) {
            RenderSystem.pushMatrix();
            RenderHelper.func_227780_a_();
            Minecraft.func_71410_x().func_175599_af().func_180450_b(item, slotX, slotY);
            RenderSystem.disableLighting();
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.popMatrix();
        }

        private boolean hasEnoughItems() {
            return this.required == this.available;
        }

        private int getTextColor() {
            return this.hasEnoughItems() ? Color.GREEN.getRGB() : Color.RED.getRGB();
        }

        public int getRequired() {
            return this.required;
        }

        public int getAvailable() {
            return this.available;
        }

        public int getMissing() {
            return this.required - this.available;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public String getItemName() {
            return this.itemName;
        }

        public String getFormattedRequired() {
            int maxSize = this.stack.func_77976_d();
            int stacks = this.required / maxSize;
            int leftover = this.required % maxSize;
            if (stacks == 0) {
                return String.valueOf(leftover);
            }
            return stacks + "\u00c3\u2014" + maxSize + "+" + leftover;
        }

        public boolean mouseClicked(double x, double y, int button) {
            return false;
        }

        public boolean isSelected() {
            return this.parent.getSelected() == this;
        }
    }
}

