/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.screen;

import com.direwolf20.buildinggadgets.client.screen.GuiMod;
import com.direwolf20.buildinggadgets.client.screen.components.GuiSliderInt;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.items.GadgetDestruction;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.packets.PacketDestructionGUI;
import com.direwolf20.buildinggadgets.common.util.lang.GuiTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class DestructionGUI
extends Screen {
    private final Set<GuiDestructionSlider> sliders = new HashSet<GuiDestructionSlider>();
    private GuiDestructionSlider left;
    private GuiDestructionSlider right;
    private GuiDestructionSlider up;
    private GuiDestructionSlider down;
    private GuiDestructionSlider depth;
    private Button confirm;
    private String sizeString = "";
    private boolean isValidSize = true;
    private final ItemStack destructionTool;

    public DestructionGUI(ItemStack tool) {
        super((ITextComponent)new StringTextComponent("Destruction Gui?!?"));
        this.destructionTool = tool;
    }

    public void init() {
        super.init();
        int x = this.width / 2;
        int y = this.height / 2;
        this.confirm = new Button(x - 30 + 32, y + 65, 60, 20, new TranslationTextComponent(GuiMod.getLangKeySingle("confirm"), new Object[0]).func_150254_d(), b -> {
            if (Minecraft.func_71410_x().field_71439_g == null) {
                return;
            }
            if (this.isWithinBounds()) {
                PacketHandler.sendToServer(new PacketDestructionGUI(this.left.getValueInt(), this.right.getValueInt(), this.up.getValueInt(), this.down.getValueInt(), this.depth.getValueInt()));
                this.onClose();
            } else {
                Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)MessageTranslation.DESTRCUT_TOO_LARGE.componentTranslation(Config.GADGETS.GADGET_DESTRUCTION.destroySize.get()), true);
            }
        });
        this.addButton((Widget)this.confirm);
        this.addButton((Widget)new Button(x - 30 - 32, y + 65, 60, 20, new TranslationTextComponent(GuiMod.getLangKeySingle("cancel"), new Object[0]).func_150254_d(), b -> this.onClose()));
        this.sliders.clear();
        this.depth = new GuiDestructionSlider(x - 35, y - 7, GuiTranslation.SINGLE_DEPTH.format(new Object[0]) + ":", GadgetDestruction.getToolValue(this.destructionTool, "depth"));
        this.sliders.add(this.depth);
        this.right = new GuiDestructionSlider(x + 75, y - 7, GuiTranslation.SINGLE_RIGHT.format(new Object[0]) + ":", GadgetDestruction.getToolValue(this.destructionTool, "right"));
        this.sliders.add(this.right);
        this.left = new GuiDestructionSlider(x - 140 - 5, y - 7, GuiTranslation.SINGLE_LEFT.format(new Object[0]) + ":", GadgetDestruction.getToolValue(this.destructionTool, "left"));
        this.sliders.add(this.left);
        this.up = new GuiDestructionSlider(x - 35, y - 35, GuiTranslation.SINGLE_UP.format(new Object[0]) + ":", GadgetDestruction.getToolValue(this.destructionTool, "up"));
        this.sliders.add(this.up);
        this.down = new GuiDestructionSlider(x - 35, y + 20, GuiTranslation.SINGLE_DOWN.format(new Object[0]) + ":", GadgetDestruction.getToolValue(this.destructionTool, "down"));
        this.sliders.add(this.down);
        this.updateSizeString();
        this.updateIsValid();
        this.sliders.forEach(gui -> gui.getComponents().forEach(arg_0 -> ((DestructionGUI)this).addButton(arg_0)));
    }

    private boolean isWithinBounds() {
        int x = this.left.getValueInt() + this.right.getValueInt();
        int y = this.up.getValueInt() + this.down.getValueInt();
        int z = this.depth.getValueInt();
        int dim = (Integer)Config.GADGETS.GADGET_DESTRUCTION.destroySize.get();
        return x <= dim && y <= dim && z <= dim;
    }

    private String getSizeString() {
        return String.format("%d x %d x %d", this.left.getValueInt() + this.right.getValueInt(), this.up.getValueInt() + this.down.getValueInt(), this.depth.getValueInt());
    }

    private void updateIsValid() {
        this.isValidSize = this.isWithinBounds();
        if (!this.isValidSize && this.confirm.active) {
            this.confirm.setFGColor(0xFF2000);
            this.confirm.active = false;
        }
        if (this.isValidSize && !this.confirm.active) {
            this.confirm.clearFGColor();
            this.confirm.active = true;
        }
    }

    private void updateSizeString() {
        this.sizeString = this.getSizeString();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        this.drawCenteredString(this.font, this.sizeString, this.width / 2, this.height / 2 + 40, this.isValidSize ? 65280 : 0xFF2000);
        if (!this.isValidSize) {
            this.drawCenteredString(this.font, MessageTranslation.DESTRCUT_TOO_LARGE.format(Config.GADGETS.GADGET_DESTRUCTION.destroySize.get()), this.width / 2, this.height / 2 + 50, 0xFF2000);
        }
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        for (GuiDestructionSlider slider : this.sliders) {
            slider.onRelease(mouseX, mouseY);
        }
        return true;
    }

    public boolean isPauseScreen() {
        return false;
    }

    private class GuiDestructionSlider
    extends GuiSliderInt {
        public static final int width = 70;
        public static final int height = 14;
        private static final int min = 0;
        private static final int max = 16;

        GuiDestructionSlider(int x, int y, String prefix, int current) {
            super(x, y, 70, 14, String.format("%s ", prefix), "", 0.0, 16.0, current, false, true, Color.DARK_GRAY, null, (slider, amount) -> {
                slider.setValue(MathHelper.func_76125_a((int)(slider.getValueInt() + amount), (int)0, (int)16));
                slider.updateSlider();
            });
        }

        @Override
        public void updateSlider() {
            super.updateSlider();
            DestructionGUI.this.updateSizeString();
            DestructionGUI.this.updateIsValid();
        }
    }
}

