/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.events;

import com.direwolf20.buildinggadgets.client.cache.RemoteInventoryCache;
import com.direwolf20.buildinggadgets.common.building.view.SimpleBuildContext;
import com.direwolf20.buildinggadgets.common.capability.CapabilityTemplate;
import com.direwolf20.buildinggadgets.common.inventory.IItemIndex;
import com.direwolf20.buildinggadgets.common.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.inventory.MatchResult;
import com.direwolf20.buildinggadgets.common.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.inventory.materials.objects.IUniqueObject;
import com.direwolf20.buildinggadgets.common.inventory.materials.objects.UniqueItem;
import com.direwolf20.buildinggadgets.common.items.OurItems;
import com.direwolf20.buildinggadgets.common.template.ITemplateKey;
import com.direwolf20.buildinggadgets.common.template.Template;
import com.direwolf20.buildinggadgets.common.template.TemplateHeader;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="buildinggadgets", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class EventTooltip {
    private static final String PLACE_HOLDER = "\u00a77\u00a7r\u00a7r\u00a7r\u00a7r\u00a7r";
    private static final Comparator<Multiset.Entry<IUniqueObject<?>>> ENTRY_COMPARATOR = Comparator.comparing(Multiset.Entry::getCount).reversed().thenComparing(e -> ((IUniqueObject)e.getElement()).getObjectRegistryName());
    private static final int STACKS_PER_LINE = 8;
    private static RemoteInventoryCache cache = new RemoteInventoryCache(true);

    public static void setCache(Multiset<IUniqueObject<?>> cache) {
        EventTooltip.cache.setCache(cache);
    }

    public static void addTemplatePadding(ItemStack stack, List<ITextComponent> tooltip) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null) {
            return;
        }
        mc.field_71441_e.getCapability(CapabilityTemplate.TEMPLATE_PROVIDER_CAPABILITY).ifPresent(provider -> stack.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).ifPresent(templateKey -> {
            MatchResult match;
            int count;
            Template template = provider.getTemplateForKey((ITemplateKey)templateKey);
            IItemIndex index = InventoryHelper.index(stack, (PlayerEntity)mc.field_71439_g);
            SimpleBuildContext buildContext = SimpleBuildContext.builder().usedStack(stack).buildingPlayer((PlayerEntity)mc.field_71439_g).build((IWorld)mc.field_71441_e);
            TemplateHeader header = template.getHeaderAndForceMaterials(buildContext);
            MaterialList list = header.getRequiredItems();
            if (list == null) {
                list = MaterialList.empty();
            }
            int n = count = (match = index.tryMatch(list)).isSuccess() ? match.getChosenOption().entrySet().size() : match.getChosenOption().entrySet().size() + 1;
            if (count > 0 && Screen.hasShiftDown()) {
                int lines = ((count - 1) / 8 + 1) * 2;
                int width = Math.min(8, count) * 18;
                String spaces = PLACE_HOLDER;
                while (mc.field_71466_p.func_78256_a(spaces) < width) {
                    spaces = spaces + " ";
                }
                for (int j = 0; j < lines; ++j) {
                    tooltip.add((ITextComponent)new StringTextComponent(spaces));
                }
            }
        }));
    }

    @SubscribeEvent
    public static void onDrawTooltip(RenderTooltipEvent.PostText event) {
        if (!Screen.hasShiftDown()) {
            return;
        }
        ItemStack stack = event.getStack();
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null) {
            return;
        }
        mc.field_71441_e.getCapability(CapabilityTemplate.TEMPLATE_PROVIDER_CAPABILITY).ifPresent(provider -> stack.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).ifPresent(templateKey -> {
            String s;
            Template template = provider.getTemplateForKey((ITemplateKey)templateKey);
            IItemIndex index = InventoryHelper.index(stack, (PlayerEntity)mc.field_71439_g);
            SimpleBuildContext buildContext = SimpleBuildContext.builder().usedStack(stack).buildingPlayer((PlayerEntity)mc.field_71439_g).build((IWorld)mc.field_71441_e);
            TemplateHeader header = template.getHeaderAndForceMaterials(buildContext);
            MaterialList list = header.getRequiredItems();
            if (list == null) {
                list = MaterialList.empty();
            }
            MatchResult match = index.tryMatch(list);
            ImmutableMultiset<IUniqueObject<?>> existing = match.getFoundItems();
            ImmutableList sortedEntries = ImmutableList.sortedCopyOf(ENTRY_COMPARATOR, (Iterable)match.getChosenOption().entrySet());
            int bx = event.getX();
            int by = event.getY();
            int j = 0;
            int totalMissing = 0;
            List tooltip = event.getLines();
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            Iterator iterator = tooltip.iterator();
            while (iterator.hasNext() && !(s = (String)iterator.next()).trim().equals(PLACE_HOLDER)) {
                fontRenderer.getClass();
                by += 9;
            }
            by += 8;
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            for (Multiset.Entry entry : sortedEntries) {
                int x = bx + j % 8 * 18;
                int y = by + j / 8 * 20;
                totalMissing += EventTooltip.renderRequiredBlocks(((IUniqueObject)entry.getElement()).createStack(), x, y, existing.count(entry.getElement()), entry.getCount());
                ++j;
            }
            if (!match.isSuccess()) {
                UniqueItem pasteItem = new UniqueItem((Item)OurItems.CONSTRUCTION_PASTE_ITEM.get());
                ImmutableMultiset pasteSet = ImmutableMultiset.builder().addCopies((Object)pasteItem, totalMissing).build();
                int hasAmt = index.tryMatch((Multiset<IUniqueObject<?>>)pasteSet).getFoundItems().count((Object)pasteItem);
                int x = bx + j % 8 * 18;
                int y = by + j / 8 * 20;
                EventTooltip.renderRequiredBlocks(pasteItem.createStack(), x, y, hasAmt, InventoryHelper.longToInt(totalMissing));
            }
        }));
    }

    private static int renderRequiredBlocks(ItemStack itemStack, int x, int y, int count, int req) {
        Minecraft mc = Minecraft.func_71410_x();
        ItemRenderer render = mc.func_175599_af();
        String s1 = req == Integer.MAX_VALUE ? "\u221e" : Integer.toString(req);
        int w1 = mc.field_71466_p.func_78256_a(s1);
        boolean hasReq = req > 0;
        render.field_77023_b += 201.0f;
        render.func_184391_a((LivingEntity)mc.field_71439_g, itemStack, x, y);
        render.func_175030_a(mc.field_71466_p, itemStack, x, y);
        render.field_77023_b -= 201.0f;
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.func_227860_a_();
        matrixstack.func_227861_a_((double)((float)(x + 8) - (float)w1 / 4.0f), (double)(y + (hasReq ? 12 : 14)), (double)(render.field_77023_b + 600.0f));
        matrixstack.func_227862_a_(0.5f, 0.5f, 0.0f);
        IRenderTypeBuffer.Impl irendertypebuffer$impl = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        mc.field_71466_p.func_228079_a_(s1, 0.0f, 0.0f, 0xFFFFFF, true, matrixstack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)irendertypebuffer$impl, false, 0, 0xF000F0);
        matrixstack.func_227865_b_();
        int missingCount = 0;
        if (hasReq && count < req) {
            String fs = Integer.toString(req - count);
            String s2 = "(" + fs + ")";
            int w2 = mc.field_71466_p.func_78256_a(s2);
            matrixstack.func_227860_a_();
            matrixstack.func_227861_a_((double)((float)(x + 8) - (float)w2 / 4.0f), (double)(y + 17), (double)(render.field_77023_b + 600.0f));
            matrixstack.func_227862_a_(0.5f, 0.5f, 0.0f);
            mc.field_71466_p.func_228079_a_(s2, 0.0f, 0.0f, 0xFF0000, true, matrixstack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)irendertypebuffer$impl, false, 0, 0xF000F0);
            matrixstack.func_227865_b_();
            missingCount = req - count;
        }
        irendertypebuffer$impl.func_228461_a_();
        return missingCount;
    }
}

