/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.uselessmod;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.uselessmod.UselessModHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"uselessmod"})
public class UselessModNonIngotModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(Arrays.asList("coal", "diamond", "emerald", "lapis", "quartz", "redstone"));

    @Override
    public String getName() {
        return "uselessmod_noningot";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.GEM, MaterialType.CRYSTAL, MaterialType.DUST);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        UselessModHelper helper = UselessModHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : moduleData.getMaterials()) {
            ResourceLocation oreLocation = miscHelper.getTagLocation("ores", material.getName());
            ResourceLocation materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
            if (material.getType() != MaterialType.DUST) {
                helper.registerCrushingRecipe(new ResourceLocation("jaopca", "uselessmod.ore_to_material." + material.getName()), oreLocation, materialLocation, 2, 0.5f, 200);
                continue;
            }
            helper.registerCrushingRecipe(new ResourceLocation("jaopca", "uselessmod.ore_to_material." + material.getName()), oreLocation, materialLocation, 5, 0.0f, 200);
        }
    }
}

