/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.thermalexpansion.recipes;

import cofh.thermal.expansion.util.recipes.machine.PressRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.compat.thermalexpansion.ThermalExpansionHelper;
import thelm.jaopca.utils.MiscHelper;

public class PressRecipeSupplier
implements Supplier<PressRecipe> {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputCount;
    public final Object secondInput;
    public final int secondInputCount;
    public final Object itemOutput;
    public final int itemOutputCount;
    public final Object fluidOutput;
    public final int fluidOutputAmount;
    public final int energy;
    public final float experience;
    public final int minTime;

    public PressRecipeSupplier(ResourceLocation key, Object input, int inputCount, Object itemOutput, int itemOutputCount, int energy, float experience, int minTime) {
        this(key, input, inputCount, null, 0, itemOutput, itemOutputCount, Fluids.field_204541_a, 0, energy, experience, minTime);
    }

    public PressRecipeSupplier(ResourceLocation key, Object input, int inputCount, Object secondInput, int secondInputCount, Object itemOutput, int itemOutputCount, int energy, float experience, int minTime) {
        this(key, input, inputCount, secondInput, secondInputCount, itemOutput, itemOutputCount, Fluids.field_204541_a, 0, energy, experience, minTime);
    }

    public PressRecipeSupplier(ResourceLocation key, Object input, int inputCount, Object secondInput, int secondInputCount, Object itemOutput, int itemOutputCount, Object fluidOutput, int fluidOutputAmount, int energy, float experience, int minTime) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputCount = inputCount;
        this.secondInput = secondInput;
        this.secondInputCount = secondInputCount;
        this.itemOutput = itemOutput;
        this.itemOutputCount = itemOutputCount;
        this.fluidOutput = fluidOutput;
        this.fluidOutputAmount = fluidOutputAmount;
        this.energy = energy;
        this.experience = experience;
        this.minTime = minTime;
    }

    @Override
    public PressRecipe get() {
        FluidStack fluidStack;
        Ingredient secondIng;
        ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
        Ingredient ing = ThermalExpansionHelper.INSTANCE.getCountedIngredient(this.input, this.inputCount);
        if (ing.func_203189_d()) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        inputs.add(ing);
        if (this.secondInput != null && (secondIng = ThermalExpansionHelper.INSTANCE.getCountedIngredient(this.secondInput, this.secondInputCount)) != Ingredient.field_193370_a && !secondIng.func_203189_d()) {
            inputs.add(secondIng);
        }
        List<Object> itemOutputs = Collections.emptyList();
        List<Object> itemChances = Collections.emptyList();
        List<Object> fluidOutputs = Collections.emptyList();
        ItemStack itemStack = MiscHelper.INSTANCE.getItemStack(this.itemOutput, this.itemOutputCount);
        if (!itemStack.func_190926_b()) {
            itemOutputs = Collections.singletonList(itemStack);
            itemChances = Collections.singletonList(Float.valueOf(-1.0f));
        }
        if (!(fluidStack = MiscHelper.INSTANCE.getFluidStack(this.fluidOutput, this.fluidOutputAmount)).isEmpty()) {
            fluidOutputs = Collections.singletonList(fluidStack);
        }
        return new PressRecipe(this.key, this.energy, this.experience, this.minTime, inputs, Collections.emptyList(), itemOutputs, itemChances, fluidOutputs);
    }
}

