/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.thermalexpansion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.ArrayUtils;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.thermalexpansion.ThermalExpansionHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"thermal_expansion"})
public class ThermalExpansionCompatModule
implements IModule {
    private static final Set<String> TO_DUST_BLACKLIST = new TreeSet<String>(Arrays.asList("bronze", "constantan", "copper", "diamond", "electrum", "emerald", "enderium", "gold", "invar", "iron", "lapis", "lead", "lumium", "nickel", "quartz", "ruby", "sapphire", "signalum", "silver", "tin"));
    private static final Set<String> TO_INGOT_BLACKLIST = new TreeSet<String>(Arrays.asList("copper", "enderium", "lead", "lumium", "nickel", "silver", "tin"));
    private static final Set<String> TO_PLATE_BLACKLIST = new TreeSet<String>(Arrays.asList("bronze", "constantan", "copper", "electrum", "enderium", "gold", "invar", "iron", "lead", "lumium", "nickel", "signalum", "silver", "tin"));
    private static final Set<String> TO_GEAR_BLACKLIST = new TreeSet<String>(Arrays.asList("bronze", "constantan", "copper", "electrum", "enderium", "gold", "invar", "iron", "lead", "lumium", "nickel", "signalum", "silver", "tin"));
    private static final Set<String> TO_COIN_BLACKLIST = new TreeSet<String>(Arrays.asList("bronze", "constantan", "copper", "electrum", "enderium", "gold", "invar", "iron", "lead", "lumium", "nickel", "signalum", "silver", "tin"));
    private static final Set<String> CREATE_TO_INGOT_BLACKLIST = new TreeSet<String>(Arrays.asList("copper", "gold", "iron", "zinc"));
    private static Set<String> configToDustBlacklist = new TreeSet<String>();
    private static Set<String> configToIngotBlacklist = new TreeSet<String>();
    private static Set<String> configToPlateBlacklist = new TreeSet<String>();
    private static Set<String> configToGearBlacklist = new TreeSet<String>();
    private static Set<String> configToCoinBlacklist = new TreeSet<String>();
    private static Set<String> configCreateToIngotBlacklist = new TreeSet<String>();

    @Override
    public String getName() {
        return "thermal_expansion_compat";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.allOf(MaterialType.class);
    }

    @Override
    public void defineModuleConfig(IModuleData moduleData, IDynamicSpecConfig config) {
        MiscHelper helper = MiscHelper.INSTANCE;
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toDustMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have pulverizer recipes added."), configToDustBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toIngotMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have smelter recipes added."), configToIngotBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toPlateMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have press to plate recipes added."), configToPlateBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toGearMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have press to gear recipes added."), configToGearBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toCoinMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have press to coin recipes added."), configToCoinBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.createToIngotMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have create compat recipes added."), configCreateToIngotBlacklist);
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        ThermalExpansionHelper helper = ThermalExpansionHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        Item richSlag = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("thermal:rich_slag"));
        Item gearDie = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("thermal:press_gear_die"));
        Item coinDie = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("thermal:press_coin_die"));
        for (IMaterial material : moduleData.getMaterials()) {
            ResourceLocation materialLocation;
            ResourceLocation materialLocation2;
            MaterialType type = material.getType();
            String name = material.getName();
            if (!(ArrayUtils.contains((Object[])MaterialType.DUSTS, (Object)((Object)type)) || TO_DUST_BLACKLIST.contains(name) || configToDustBlacklist.contains(name))) {
                materialLocation2 = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
                ResourceLocation dustLocation = miscHelper.getTagLocation("dusts", material.getName());
                if (((JAOPCAApi)api).getItemTags().contains(dustLocation)) {
                    helper.registerPulverizerRecipe(new ResourceLocation("jaopca", "thermal_expansion.material_to_dust." + material.getName()), materialLocation2, 1, new Object[]{dustLocation}, 2000, 0.0f, -1);
                }
            }
            if (ArrayUtils.contains((Object[])MaterialType.INGOTS, (Object)((Object)type)) && !TO_INGOT_BLACKLIST.contains(name) && !configToIngotBlacklist.contains(name)) {
                ResourceLocation dustLocation = miscHelper.getTagLocation("dusts", material.getName());
                materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
                if (((JAOPCAApi)api).getItemTags().contains(dustLocation)) {
                    helper.registerSmelterRecipe(new ResourceLocation("jaopca", "thermal_expansion.dust_to_material." + material.getName()), new Object[]{dustLocation}, new Object[]{materialLocation}, 1600, 0.0f, -1);
                }
            }
            if (ArrayUtils.contains((Object[])MaterialType.INGOTS, (Object)((Object)type)) && !TO_PLATE_BLACKLIST.contains(name) && !configToPlateBlacklist.contains(name)) {
                materialLocation2 = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
                ResourceLocation plateLocation = miscHelper.getTagLocation("plates", material.getName());
                if (((JAOPCAApi)api).getItemTags().contains(plateLocation)) {
                    helper.registerPressRecipe(new ResourceLocation("jaopca", "thermal_expansion.material_to_plate." + material.getName()), materialLocation2, 1, plateLocation, 1, 2400, 0.0f, -1);
                }
            }
            if (ArrayUtils.contains((Object[])MaterialType.INGOTS, (Object)((Object)type)) && !TO_GEAR_BLACKLIST.contains(name) && !configToGearBlacklist.contains(name)) {
                materialLocation2 = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
                ResourceLocation gearLocation = miscHelper.getTagLocation("gears", material.getName());
                if (((JAOPCAApi)api).getItemTags().contains(gearLocation)) {
                    helper.registerPressRecipe(new ResourceLocation("jaopca", "thermal_expansion.material_to_gear." + material.getName()), materialLocation2, 3, gearDie, 1, gearLocation, 1, 2400, 0.0f, -1);
                }
            }
            if (ArrayUtils.contains((Object[])MaterialType.INGOTS, (Object)((Object)type)) && !TO_COIN_BLACKLIST.contains(name) && !configToCoinBlacklist.contains(name)) {
                materialLocation2 = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
                ResourceLocation nuggetLocation = miscHelper.getTagLocation("nuggets", material.getName());
                ResourceLocation coinLocation = miscHelper.getTagLocation("coins", material.getName());
                if (((JAOPCAApi)api).getItemTags().contains(coinLocation)) {
                    helper.registerPressRecipe(new ResourceLocation("jaopca", "thermal_expansion.material_to_coin." + material.getName()), materialLocation2, 1, coinDie, 1, coinLocation, 3, 2400, 0.0f, -1);
                    if (((JAOPCAApi)api).getItemTags().contains(nuggetLocation)) {
                        helper.registerPressRecipe(new ResourceLocation("jaopca", "thermal_expansion.nugget_to_coin." + material.getName()), nuggetLocation, 3, coinDie, 1, coinLocation, 1, 800, 0.0f, -1);
                    }
                }
            }
            if (!ArrayUtils.contains((Object[])MaterialType.INGOTS, (Object)((Object)type)) || CREATE_TO_INGOT_BLACKLIST.contains(name) || configCreateToIngotBlacklist.contains(name)) continue;
            ResourceLocation crushedOreLocation = miscHelper.getTagLocation("create:crushed_ores", material.getName());
            materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
            ResourceLocation extraMaterialLocation = miscHelper.getTagLocation(material.getExtra(1).getType().getFormName(), material.getExtra(1).getName());
            if (!((JAOPCAApi)api).getItemTags().contains(crushedOreLocation)) continue;
            if (material.hasExtra(1)) {
                helper.registerSmelterRecipe(new ResourceLocation("jaopca", "thermal_expansion.create_crushed_ore_to_material." + material.getName()), new Object[]{crushedOreLocation}, new Object[]{materialLocation, Float.valueOf(1.0f), extraMaterialLocation, Float.valueOf(0.2f), richSlag, Float.valueOf(0.2f)}, 3200, 0.2f, -1);
                continue;
            }
            helper.registerSmelterRecipe(new ResourceLocation("jaopca", "thermal_expansion.create_crushed_ore_to_material." + material.getName()), new Object[]{crushedOreLocation}, new Object[]{materialLocation, Float.valueOf(1.0f), richSlag, Float.valueOf(0.2f)}, 3200, 0.2f, -1);
        }
    }

    static {
        if (ModList.get().isLoaded("appliedenergistics2")) {
            Collections.addAll(TO_DUST_BLACKLIST, "ender_pearl", "fluix");
        }
        if (ModList.get().isLoaded("immersiveengineering")) {
            Collections.addAll(TO_PLATE_BLACKLIST, "uranium");
        }
        if (ModList.get().isLoaded("silents_mechanisms")) {
            Collections.addAll(TO_DUST_BLACKLIST, "brass");
            Collections.addAll(TO_INGOT_BLACKLIST, "brass");
        }
    }
}

