/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.integrateddynamics.recipes;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSqueezer;
import thelm.jaopca.utils.MiscHelper;

public class SqueezerRecipeSupplier
implements Supplier<RecipeSqueezer> {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final Object[] itemOutput;
    public final Object fluidOutput;
    public final int fluidOutputAmount;

    public SqueezerRecipeSupplier(ResourceLocation key, Object input, Object[] itemOutput) {
        this(key, input, itemOutput, Fluids.field_204541_a, 0);
    }

    public SqueezerRecipeSupplier(ResourceLocation key, Object input, Object[] itemOutput, Object fluidOutput, int fluidOutputAmount) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.itemOutput = itemOutput;
        this.fluidOutput = fluidOutput;
        this.fluidOutputAmount = fluidOutputAmount;
    }

    @Override
    public RecipeSqueezer get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing.func_203189_d()) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        NonNullList itemResults = NonNullList.func_191196_a();
        int i = 0;
        while (i < this.itemOutput.length) {
            ItemStack stack;
            Object out = this.itemOutput[i];
            Integer count = 1;
            if (++i < this.itemOutput.length && this.itemOutput[i] instanceof Integer) {
                count = (Integer)this.itemOutput[i];
                ++i;
            }
            Float chance = Float.valueOf(1.0f);
            if (i < this.itemOutput.length && this.itemOutput[i] instanceof Float) {
                chance = (Float)this.itemOutput[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)).func_190926_b()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
            }
            itemResults.add((Object)new RecipeSqueezer.ItemStackChance(stack, chance.floatValue()));
        }
        FluidStack fluidStack = MiscHelper.INSTANCE.getFluidStack(this.fluidOutput, this.fluidOutputAmount);
        return new RecipeSqueezer(this.key, ing, itemResults, fluidStack);
    }
}

