/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.indreb.recipes;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.maciej916.indreb.common.receipe.CrushingRecipe;
import com.maciej916.indreb.common.receipe.basic.ChanceResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.utils.MiscHelper;

public class CrushingRecipeSupplier
implements Supplier<CrushingRecipe> {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final String group;
    public final Object input;
    public final int inputCount;
    public final Object output;
    public final int outputCount;
    public final Object secondOutput;
    public final int secondOutputCount;
    public final float secondChance;
    public final int time;
    public final int power;

    public CrushingRecipeSupplier(ResourceLocation key, Object input, int inputCount, Object output, int outputCount, int time, int power) {
        this(key, "", input, inputCount, output, outputCount, ItemStack.field_190927_a, 0, 0.0f, time, power);
    }

    public CrushingRecipeSupplier(ResourceLocation key, String group, Object input, int inputCount, Object output, int outputCount, int time, int power) {
        this(key, group, input, inputCount, output, outputCount, ItemStack.field_190927_a, 0, 0.0f, time, power);
    }

    public CrushingRecipeSupplier(ResourceLocation key, Object input, int inputCount, Object output, int outputCount, Object secondOutput, int secondCount, float secondChance, int time, int power) {
        this(key, "", input, inputCount, output, outputCount, secondOutput, secondCount, secondChance, time, power);
    }

    public CrushingRecipeSupplier(ResourceLocation key, String group, Object input, int inputCount, Object output, int outputCount, Object secondOutput, int secondOutputCount, float secondChance, int time, int power) {
        this.key = Objects.requireNonNull(key);
        this.group = Strings.nullToEmpty((String)group);
        this.input = input;
        this.inputCount = inputCount;
        this.output = output;
        this.outputCount = outputCount;
        this.secondOutput = secondOutput;
        this.secondOutputCount = secondOutputCount;
        this.secondChance = secondChance;
        this.time = time;
        this.power = power;
    }

    @Override
    public CrushingRecipe get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing.func_203189_d()) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.func_190926_b()) {
            LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, this.output);
        }
        ItemStack secondStack = MiscHelper.INSTANCE.getItemStack(this.secondOutput, this.secondOutputCount);
        if (this.secondChance > 0.0f && secondStack.func_190926_b()) {
            LOGGER.warn("Empty non-zero chance second output in recipe {}: {}", (Object)this.key, this.secondOutput);
        }
        ArrayList result = Lists.newArrayList((Object[])new ChanceResult[]{new ChanceResult(secondStack, this.secondOutputCount, this.secondChance)});
        return new CrushingRecipe(this.key, ing, this.inputCount, stack, (List)result, this.time, this.power);
    }
}

