/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.flux;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.commons.lang3.ArrayUtils;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.flux.FluxHelper;
import thelm.jaopca.items.ItemFormType;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"flux@[4.16.1,)"})
public class FluxCompatModule
implements IModule {
    private static final Set<String> TO_DUST_BLACKLIST = new TreeSet<String>(Arrays.asList("bronze", "copper", "gold", "iron", "lead", "osmium", "silver", "steel", "tin"));
    private static final Set<String> TO_PLATE_BLACKLIST = new TreeSet<String>(Arrays.asList("bronze", "copper", "gold", "iron", "steel", "tin"));
    private static Set<String> configToDustBlacklist = new TreeSet<String>();
    private static Set<String> configToPlateBlacklist = new TreeSet<String>();

    @Override
    public String getName() {
        return "flux_compat";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.allOf(MaterialType.class);
    }

    @Override
    public void defineModuleConfig(IModuleData moduleData, IDynamicSpecConfig config) {
        MiscHelper helper = MiscHelper.INSTANCE;
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toDustMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have grinding recipes added."), configToDustBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toPlateMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have compacting recipes added."), configToPlateBlacklist);
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        FluxHelper helper = FluxHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        ItemFormType itemFormType = ItemFormType.INSTANCE;
        for (IMaterial material : moduleData.getMaterials()) {
            ResourceLocation materialLocation;
            MaterialType type = material.getType();
            String name = material.getName();
            if (!(ArrayUtils.contains((Object[])MaterialType.DUSTS, (Object)((Object)type)) || TO_DUST_BLACKLIST.contains(material.getName()) || configToDustBlacklist.contains(name))) {
                materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
                ResourceLocation dustLocation = miscHelper.getTagLocation("dusts", material.getName());
                if (((JAOPCAApi)api).getItemTags().contains(dustLocation)) {
                    helper.registerGrindingRecipe(new ResourceLocation("jaopca", "flux.material_to_dust." + material.getName()), materialLocation, 1, dustLocation, 1, 0.0f, 200);
                }
            }
            if (!ArrayUtils.contains((Object[])MaterialType.INGOTS, (Object)((Object)type)) || TO_PLATE_BLACKLIST.contains(material.getName()) || configToPlateBlacklist.contains(name)) continue;
            materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
            ResourceLocation plateLocation = miscHelper.getTagLocation("plates", material.getName());
            if (!((JAOPCAApi)api).getItemTags().contains(plateLocation)) continue;
            helper.registerCompactingRecipe(new ResourceLocation("jaopca", "flux.material_to_plate." + material.getName()), materialLocation, 1, plateLocation, 1, 0.0f, 200);
        }
    }
}

