/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.crossroads.recipes;

import com.Da_Technomancer.crossroads.items.crafting.recipes.BlastFurnaceRec;
import com.google.common.base.Strings;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.utils.MiscHelper;

public class BlastFurnaceRecipeSupplier
implements Supplier<BlastFurnaceRec> {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final String group;
    public final Object input;
    public final Object output;
    public final int amount;
    public final int slagCount;

    public BlastFurnaceRecipeSupplier(ResourceLocation key, Object input, Object output, int amount, int slagCount) {
        this(key, "", input, output, amount, slagCount);
    }

    public BlastFurnaceRecipeSupplier(ResourceLocation key, String group, Object input, Object output, int amount, int slagCount) {
        this.key = Objects.requireNonNull(key);
        this.group = Strings.nullToEmpty((String)group);
        this.input = input;
        this.output = output;
        this.amount = amount;
        this.slagCount = slagCount;
    }

    @Override
    public BlastFurnaceRec get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing.func_203189_d()) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        FluidStack stack = MiscHelper.INSTANCE.getFluidStack(this.output, this.amount);
        if (stack.isEmpty()) {
            LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, this.output);
        }
        return new BlastFurnaceRec(this.key, this.group, ing, stack, this.slagCount, true);
    }
}

