/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.create.recipes;

import com.simibubi.create.content.contraptions.components.press.PressingRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeBuilder;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.utils.MiscHelper;

public class PressingRecipeSupplier
implements Supplier<PressingRecipe> {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final Object output;
    public final int outputCount;

    public PressingRecipeSupplier(ResourceLocation key, Object input, Object output, int outputCount) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.output = output;
        this.outputCount = outputCount;
    }

    @Override
    public PressingRecipe get() {
        ProcessingRecipeBuilder builder = new ProcessingRecipeBuilder(PressingRecipe::new, this.key);
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing.func_203189_d()) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        builder.require(ing);
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.getStack().func_190926_b()) {
            LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, this.output);
        }
        builder.output(stack);
        return (PressingRecipe)builder.build();
    }
}

