/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.create.recipes;

import com.simibubi.create.content.contraptions.components.millstone.MillingRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeBuilder;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.utils.MiscHelper;

public class MillingRecipeSupplier
implements Supplier<MillingRecipe> {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final Object[] output;
    public final int time;

    public MillingRecipeSupplier(ResourceLocation key, Object input, int time, Object ... output) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.output = output;
        this.time = time;
    }

    @Override
    public MillingRecipe get() {
        ProcessingRecipeBuilder builder = new ProcessingRecipeBuilder(MillingRecipe::new, this.key);
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing.func_203189_d()) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        builder.require(ing);
        int i = 0;
        while (i < this.output.length) {
            ItemStack stack;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            Float chance = Float.valueOf(1.0f);
            if (i < this.output.length && this.output[i] instanceof Float) {
                chance = (Float)this.output[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)).func_190926_b()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
            }
            builder.output(chance.floatValue(), stack);
        }
        return (MillingRecipe)builder.duration(this.time).build();
    }
}

