/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.handler;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.awt.Color;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.common.multiblock.StateMatcher;
import vazkii.patchouli.common.util.RotationUtil;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class MultiblockVisualizationHandler {
    public static boolean hasMultiblock;
    public static PersistentData.DataHolder.BookData.Bookmark bookmark;
    private static IMultiblock multiblock;
    private static ITextComponent name;
    private static BlockPos pos;
    private static boolean isAnchored;
    private static Rotation facingRotation;
    private static Function<BlockPos, BlockPos> offsetApplier;
    private static int blocks;
    private static int blocksDone;
    private static int airFilled;
    private static int timeComplete;
    private static BlockState lookingState;
    private static BlockPos lookingPos;
    private static IRenderTypeBuffer.Impl buffers;

    public static void setMultiblock(IMultiblock multiblock, String name, PersistentData.DataHolder.BookData.Bookmark bookmark, boolean flip) {
        MultiblockVisualizationHandler.setMultiblock(multiblock, (ITextComponent)new StringTextComponent(name == null ? "" : name), bookmark, flip);
    }

    public static void setMultiblock(IMultiblock multiblock, ITextComponent name, PersistentData.DataHolder.BookData.Bookmark bookmark, boolean flip) {
        MultiblockVisualizationHandler.setMultiblock(multiblock, name, bookmark, flip, pos -> pos);
    }

    public static void setMultiblock(IMultiblock multiblock, ITextComponent name, PersistentData.DataHolder.BookData.Bookmark bookmark, boolean flip, Function<BlockPos, BlockPos> offsetApplier) {
        if (flip && hasMultiblock) {
            hasMultiblock = false;
        } else {
            MultiblockVisualizationHandler.multiblock = multiblock;
            MultiblockVisualizationHandler.name = name;
            MultiblockVisualizationHandler.bookmark = bookmark;
            MultiblockVisualizationHandler.offsetApplier = offsetApplier;
            pos = null;
            hasMultiblock = multiblock != null;
            isAnchored = false;
        }
    }

    @SubscribeEvent
    public static void onRenderHUD(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && hasMultiblock) {
            int fullAnimTime;
            int waitTime = 40;
            int fadeOutSpeed = 4;
            float animTime = (float)timeComplete + (timeComplete == 0 ? 0.0f : event.getPartialTicks());
            if (animTime > (float)(fullAnimTime = waitTime + 10)) {
                hasMultiblock = false;
                return;
            }
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)0.0f, (float)(-Math.max(0.0f, animTime - (float)waitTime) * (float)fadeOutSpeed), (float)0.0f);
            int x = event.getWindow().func_198107_o() / 2;
            int y = 12;
            Minecraft mc = Minecraft.func_71410_x();
            String toDraw = name.func_150254_d();
            mc.field_71466_p.func_175063_a(toDraw, (float)(x - mc.field_71466_p.func_78256_a(toDraw) / 2), (float)y, 0xFFFFFF);
            int width = 180;
            int height = 9;
            int left = x - width / 2;
            int top = y + 10;
            if (timeComplete > 0) {
                String s = I18n.func_135052_a((String)"patchouli.gui.lexicon.structure_complete", (Object[])new Object[0]);
                RenderSystem.pushMatrix();
                RenderSystem.translatef((float)0.0f, (float)Math.min((float)(height + 5), animTime), (float)0.0f);
                mc.field_71466_p.func_175063_a(s, (float)(x - mc.field_71466_p.func_78256_a(s) / 2), (float)(top + height - 10), 65280);
                RenderSystem.popMatrix();
            }
            AbstractGui.fill((int)(left - 1), (int)(top - 1), (int)(left + width + 1), (int)(top + height + 1), (int)-16777216);
            MultiblockVisualizationHandler.drawGradientRect(left, top, left + width, top + height, -10066330, -11184811);
            float fract = (float)blocksDone / (float)Math.max(1, blocks);
            int progressWidth = (int)((float)width * fract);
            int color = MathHelper.func_181758_c((float)(fract / 3.0f), (float)1.0f, (float)1.0f) | 0xFF000000;
            int color2 = new Color(color).darker().getRGB();
            MultiblockVisualizationHandler.drawGradientRect(left, top, left + progressWidth, top + height, color, color2);
            if (!isAnchored) {
                String s = I18n.func_135052_a((String)"patchouli.gui.lexicon.not_anchored", (Object[])new Object[0]);
                mc.field_71466_p.func_175063_a(s, (float)(x - mc.field_71466_p.func_78256_a(s) / 2), (float)(top + height + 8), 0xFFFFFF);
            } else {
                if (lookingState != null) {
                    try {
                        Block block = lookingState.func_177230_c();
                        ItemStack stack = block.getPickBlock(lookingState, mc.field_71476_x, (IBlockReader)mc.field_71441_e, lookingPos, (PlayerEntity)mc.field_71439_g);
                        if (!stack.func_190926_b()) {
                            mc.field_71466_p.func_175063_a(stack.func_200301_q().func_150254_d(), (float)(left + 20), (float)(top + height + 8), 0xFFFFFF);
                            mc.func_175599_af().func_175042_a(stack, left, top + height + 2);
                        }
                    }
                    catch (Exception block) {
                        // empty catch block
                    }
                }
                if (timeComplete == 0) {
                    color = 0xFFFFFF;
                    int posx = left + width;
                    int posy = top + height + 2;
                    int mult = 1;
                    String progress = blocksDone + "/" + blocks;
                    if (blocksDone == blocks && airFilled > 0) {
                        progress = I18n.func_135052_a((String)"patchouli.gui.lexicon.needs_air", (Object[])new Object[0]);
                        color = 14306879;
                        mult *= 2;
                        posx -= width / 2;
                        posy += 2;
                    }
                    mc.field_71466_p.func_175063_a(progress, (float)(posx - mc.field_71466_p.func_78256_a(progress) / mult), (float)posy, color);
                }
            }
            RenderSystem.popMatrix();
        }
    }

    @SubscribeEvent
    public static void onWorldRenderLast(RenderWorldLastEvent event) {
        if (hasMultiblock && multiblock != null) {
            MultiblockVisualizationHandler.renderMultiblock((World)Minecraft.func_71410_x().field_71441_e, event.getMatrixStack());
        }
    }

    public static void anchorTo(BlockPos target, Rotation rot) {
        pos = target;
        facingRotation = rot;
        isAnchored = true;
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (hasMultiblock && !isAnchored && event.getPlayer() == Minecraft.func_71410_x().field_71439_g) {
            MultiblockVisualizationHandler.anchorTo(event.getPos(), MultiblockVisualizationHandler.getRotation((Entity)event.getPlayer()));
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            hasMultiblock = false;
        } else if (isAnchored && blocks == blocksDone && airFilled == 0) {
            if (++timeComplete == 14) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187604_bf, (float)1.0f));
            }
        } else {
            timeComplete = 0;
        }
    }

    public static void renderMultiblock(World world, MatrixStack ms) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!isAnchored) {
            facingRotation = MultiblockVisualizationHandler.getRotation((Entity)mc.field_71439_g);
            if (mc.field_71476_x instanceof BlockRayTraceResult) {
                pos = ((BlockRayTraceResult)mc.field_71476_x).func_216350_a();
            }
        } else if (pos.func_218138_a((IPosition)mc.field_71439_g.func_213303_ch(), false) > 4096.0) {
            return;
        }
        if (pos == null) {
            return;
        }
        if (multiblock.isSymmetrical()) {
            facingRotation = Rotation.NONE;
        }
        EntityRendererManager erd = mc.func_175598_ae();
        double renderPosX = erd.field_217783_c.func_216785_c().func_82615_a();
        double renderPosY = erd.field_217783_c.func_216785_c().func_82617_b();
        double renderPosZ = erd.field_217783_c.func_216785_c().func_82616_c();
        ms.func_227861_a_(-renderPosX, -renderPosY, -renderPosZ);
        if (buffers == null) {
            buffers = MultiblockVisualizationHandler.initBuffers(mc.func_228019_au_().func_228487_b_());
        }
        BlockPos checkPos = null;
        if (mc.field_71476_x instanceof BlockRayTraceResult) {
            BlockRayTraceResult blockRes = (BlockRayTraceResult)mc.field_71476_x;
            checkPos = blockRes.func_216350_a().func_177972_a(blockRes.func_216354_b());
        }
        airFilled = 0;
        blocksDone = 0;
        blocks = 0;
        lookingState = null;
        lookingPos = checkPos;
        Pair<BlockPos, Collection<IMultiblock.SimulateResult>> sim = multiblock.simulate(world, MultiblockVisualizationHandler.getStartPos(), MultiblockVisualizationHandler.getFacingRotation(), true);
        for (IMultiblock.SimulateResult r : (Collection)sim.getSecond()) {
            boolean air;
            float alpha = 0.3f;
            if (r.getWorldPosition().equals((Object)checkPos)) {
                lookingState = r.getStateMatcher().getDisplayedState((int)ClientTicker.ticksInGame);
                alpha = 0.6f + (float)(Math.sin(ClientTicker.total * 0.3f) + 1.0) * 0.1f;
            }
            if (r.getStateMatcher() == StateMatcher.ANY) continue;
            boolean bl = air = r.getStateMatcher() == StateMatcher.AIR;
            if (!air) {
                ++blocks;
            }
            if (!r.test(world, facingRotation)) {
                BlockState renderState = r.getStateMatcher().getDisplayedState((int)ClientTicker.ticksInGame).func_185907_a(facingRotation);
                MultiblockVisualizationHandler.renderBlock(world, renderState, r.getWorldPosition(), alpha, ms);
                if (!air) continue;
                ++airFilled;
                continue;
            }
            if (air) continue;
            ++blocksDone;
        }
        buffers.func_228461_a_();
        if (!isAnchored) {
            blocksDone = 0;
            blocks = 0;
        }
    }

    public static void renderBlock(World world, BlockState state, BlockPos pos, float alpha, MatrixStack ms) {
        if (pos != null) {
            ms.func_227860_a_();
            ms.func_227861_a_((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            if (state.func_177230_c() == Blocks.field_150350_a) {
                float scale = 0.3f;
                float off = (1.0f - scale) / 2.0f;
                ms.func_227861_a_((double)off, (double)off, (double)(-off));
                ms.func_227862_a_(scale, scale, scale);
                state = Blocks.field_196856_iQ.func_176223_P();
            }
            Minecraft.func_71410_x().func_175602_ab().func_228791_a_(state, ms, (IRenderTypeBuffer)buffers, 0xF000F0, OverlayTexture.field_229196_a_);
            ms.func_227865_b_();
        }
    }

    public static IMultiblock getMultiblock() {
        return multiblock;
    }

    public static boolean isAnchored() {
        return isAnchored;
    }

    public static Rotation getFacingRotation() {
        return multiblock.isSymmetrical() ? Rotation.NONE : facingRotation;
    }

    public static BlockPos getStartPos() {
        return offsetApplier.apply(pos);
    }

    private static void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_225582_a_((double)right, (double)top, 0.0).func_227885_a_(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_225582_a_((double)left, (double)top, 0.0).func_227885_a_(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_225582_a_((double)left, (double)bottom, 0.0).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        bufferbuilder.func_225582_a_((double)right, (double)bottom, 0.0).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    private static Rotation getRotation(Entity entity) {
        return RotationUtil.rotationFromFacing(entity.func_174811_aO());
    }

    private static IRenderTypeBuffer.Impl initBuffers(IRenderTypeBuffer.Impl original) {
        BufferBuilder fallback = (BufferBuilder)ObfuscationReflectionHelper.getPrivateValue(IRenderTypeBuffer.Impl.class, (Object)original, (String)"field_228457_a_");
        Map layerBuffers = (Map)ObfuscationReflectionHelper.getPrivateValue(IRenderTypeBuffer.Impl.class, (Object)original, (String)"field_228458_b_");
        Object2ObjectLinkedOpenHashMap remapped = new Object2ObjectLinkedOpenHashMap();
        for (Map.Entry e : layerBuffers.entrySet()) {
            remapped.put(GhostRenderType.remap((RenderType)e.getKey()), e.getValue());
        }
        return new GhostBuffers(fallback, (Map<RenderType, BufferBuilder>)remapped);
    }

    static {
        buffers = null;
    }

    private static class GhostRenderType
    extends RenderType {
        private static Map<RenderType, RenderType> remappedTypes = new IdentityHashMap<RenderType, RenderType>();

        private GhostRenderType(RenderType original) {
            super(String.format("%s_%s_ghost", original.toString(), "patchouli"), original.func_228663_p_(), original.func_228664_q_(), original.func_228662_o_(), original.func_228665_s_(), true, () -> {
                original.func_228547_a_();
                RenderSystem.disableDepthTest();
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.CONSTANT_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_CONSTANT_ALPHA);
                RenderSystem.blendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
            }, () -> {
                RenderSystem.blendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableBlend();
                RenderSystem.enableDepthTest();
                original.func_228549_b_();
            });
        }

        public boolean equals(@Nullable Object other) {
            return this == other;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }

        public static RenderType remap(RenderType in) {
            if (in instanceof GhostRenderType) {
                return in;
            }
            return remappedTypes.computeIfAbsent(in, GhostRenderType::new);
        }
    }

    private static class GhostBuffers
    extends IRenderTypeBuffer.Impl {
        protected GhostBuffers(BufferBuilder fallback, Map<RenderType, BufferBuilder> layerBuffers) {
            super(fallback, layerBuffers);
        }

        public IVertexBuilder getBuffer(RenderType type) {
            return super.getBuffer(GhostRenderType.remap(type));
        }
    }
}

