/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import vazkii.patchouli.common.base.Patchouli;
import vazkii.patchouli.common.util.ItemStackUtil;

public class BookIcon {
    private static final BookIcon EMPTY = new BookIcon(ItemStack.field_190927_a);
    private final IconType type;
    private final ItemStack stack;
    private final ResourceLocation res;

    public static BookIcon from(String str) {
        if (str.endsWith(".png")) {
            return new BookIcon(new ResourceLocation(str));
        }
        try {
            ItemStack stack = ItemStackUtil.loadStackFromString(str);
            return new BookIcon(stack);
        }
        catch (Exception e) {
            Patchouli.LOGGER.warn("Invalid icon item stack: {}", (Object)e.getMessage());
            return EMPTY;
        }
    }

    public BookIcon(ItemStack stack) {
        this.type = IconType.STACK;
        this.stack = stack;
        this.res = null;
    }

    public BookIcon(ResourceLocation res) {
        this.type = IconType.RESOURCE;
        this.stack = null;
        this.res = res;
    }

    public void render(int x, int y) {
        Minecraft mc = Minecraft.func_71410_x();
        switch (this.type) {
            case STACK: {
                mc.func_175599_af().func_175042_a(this.stack, x, y);
                break;
            }
            case RESOURCE: {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.field_71446_o.func_110577_a(this.res);
                AbstractGui.blit((int)x, (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            }
        }
    }

    private static enum IconType {
        STACK,
        RESOURCE;

    }
}

