/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.entity;

import com.mrcrayfish.goblintraders.entity.ai.goal.AttackRevengeTargetGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.EatFavouriteFoodGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.FindFavouriteFoodGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.FollowPotentialCustomerGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.LookAtCustomerGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.TradeWithPlayerGoal;
import com.mrcrayfish.goblintraders.init.ModSounds;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.INPC;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookAtWithoutMovingGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.merchant.IMerchant;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;

public abstract class AbstractGoblinEntity
extends CreatureEntity
implements INPC,
IMerchant {
    protected static final int BASE_TRADES = 0;
    protected static final int RARE_TRADES = 1;
    public static final DataParameter<Boolean> STUNNED = EntityDataManager.func_187226_a(AbstractGoblinEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    @Nullable
    private PlayerEntity customer;
    private Set<UUID> tradedCustomers = new HashSet<UUID>();
    @Nullable
    private MerchantOffers offers;
    private int stunDelay;
    private int despawnDelay;
    private int fallCounter;

    protected AbstractGoblinEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new TradeWithPlayerGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtCustomerGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new AttackRevengeTargetGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowPotentialCustomerGoal(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new FindFavouriteFoodGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new EatFavouriteFoodGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.4));
        this.field_70714_bg.func_75776_a(8, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 0.4));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtWithoutMovingGoal((MobEntity)this, PlayerEntity.class, 4.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STUNNED, (Object)false);
    }

    public abstract ResourceLocation getTexture();

    public int getFallCounter() {
        return this.fallCounter;
    }

    public ItemStack func_213357_a(World world, ItemStack stack) {
        if (stack.func_77973_b() == this.getFavouriteFood().func_77973_b() && stack.func_77973_b().func_219967_s() != null) {
            this.func_70606_j(this.func_110143_aJ() + (float)stack.func_77973_b().func_219967_s().func_221466_a());
        }
        return super.func_213357_a(world, stack);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.func_82168_bl();
        if (this.stunDelay > 0) {
            --this.stunDelay;
            if (this.stunDelay == 0) {
                this.field_70180_af.func_187227_b(STUNNED, (Object)false);
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), ModSounds.ENTITY_GOBLIN_TRADER_ANNOYED_GRUNT, SoundCategory.NEUTRAL, 1.0f, 0.9f + this.func_70681_au().nextFloat() * 0.2f);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.handleDespawn();
        } else if (((Boolean)this.field_70180_af.func_187225_a(STUNNED)).booleanValue()) {
            if (this.fallCounter < 10) {
                ++this.fallCounter;
            }
        } else {
            this.fallCounter = 0;
        }
    }

    public void func_70932_a_(@Nullable PlayerEntity player) {
        if (player == null && this.customer != null && !this.isPreviousCustomer(this.customer) && this.field_70146_Z.nextInt(5) == 0) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), ModSounds.ENTITY_GOBLIN_TRADER_ANNOYED_GRUNT, SoundCategory.NEUTRAL, 1.0f, 0.9f + this.func_70681_au().nextFloat() * 0.2f);
            this.customer.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 0.5f);
            this.func_184609_a(Hand.MAIN_HAND);
        }
        this.customer = player;
    }

    @Nullable
    public PlayerEntity func_70931_l_() {
        return this.customer;
    }

    public boolean hasCustomer() {
        return this.customer != null;
    }

    public MerchantOffers func_213706_dY() {
        if (this.offers == null) {
            this.offers = new MerchantOffers();
            this.populateTradeData();
        }
        return this.offers;
    }

    protected abstract void populateTradeData();

    protected void addTrades(MerchantOffers offers, @Nullable VillagerTrades.ITrade[] trades, int max) {
        if (trades == null) {
            return;
        }
        List randomIndexes = IntStream.range(0, trades.length).boxed().collect(Collectors.toList());
        Collections.shuffle(randomIndexes);
        randomIndexes = randomIndexes.subList(0, Math.min(trades.length, max));
        for (Integer index : randomIndexes) {
            VillagerTrades.ITrade trade = trades[index];
            MerchantOffer offer = trade.func_221182_a((Entity)this, this.field_70146_Z);
            if (offer == null) continue;
            offers.add((Object)offer);
        }
    }

    public void func_213703_a(@Nullable MerchantOffers offers) {
    }

    public void func_213704_a(MerchantOffer offer) {
        offer.func_222219_j();
        if (this.customer != null) {
            this.tradedCustomers.add(this.customer.func_110124_au());
        }
    }

    public void func_110297_a_(ItemStack stack) {
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    public int func_213708_dV() {
        return 0;
    }

    public void func_213702_q(int xpIn) {
    }

    public boolean func_213705_dZ() {
        return false;
    }

    public SoundEvent func_213714_ea() {
        return SoundEvents.field_187915_go;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_77973_b() == Items.field_151057_cb) {
            heldItem.func_111282_a(player, (LivingEntity)this, hand);
            return true;
        }
        if (this.func_70089_S() && !this.hasCustomer() && !this.func_70631_g_()) {
            if (this.func_213706_dY().isEmpty()) {
                return super.func_184645_a(player, hand);
            }
            if (!(this.field_70170_p.field_72995_K || this.func_70643_av() != null && this.func_70643_av() == player)) {
                this.func_70932_a_(player);
                this.func_213707_a(player, this.func_145748_c_(), 1);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean isPreviousCustomer(PlayerEntity player) {
        return this.tradedCustomers.contains(player.func_110124_au());
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean attacked = super.func_70097_a(source, amount);
        if (attacked) {
            this.field_70180_af.func_187227_b(STUNNED, (Object)true);
            this.field_70714_bg.func_220888_c().forEach(PrioritizedGoal::func_75251_c);
            this.stunDelay = 20;
        }
        return attacked;
    }

    public int getStunDelay() {
        return this.stunDelay;
    }

    public void setDespawnDelay(int despawnDelay) {
        this.despawnDelay = despawnDelay;
    }

    public int getDespawnDelay() {
        return this.despawnDelay;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Offers", 10)) {
            this.offers = new MerchantOffers(compound.func_74775_l("Offers"));
        }
        if (compound.func_150297_b("DespawnDelay", 3)) {
            this.despawnDelay = compound.func_74762_e("DespawnDelay");
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        MerchantOffers merchantoffers = this.func_213706_dY();
        if (!merchantoffers.isEmpty()) {
            compound.func_218657_a("Offers", (INBT)merchantoffers.func_222199_a());
        }
        compound.func_74768_a("DespawnDelay", this.despawnDelay);
    }

    private void handleDespawn() {
        if (this.despawnDelay > 0 && !this.hasCustomer() && --this.despawnDelay == 0) {
            this.func_70106_y();
        }
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return ModSounds.ENTITY_GOBLIN_TRADER_IDLE_GRUNT;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ModSounds.ENTITY_GOBLIN_TRADER_IDLE_GRUNT;
    }

    public abstract ItemStack getFavouriteFood();
}

