/*
 * Decompiled with CFR 0.152.
 */
package rocks.gameonthe.rockytweaks.crafttweaker.merchant;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.village.MerchantRecipe;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public final class VillagerHelper {
    private VillagerHelper() {
    }

    public static Collection<VillagerRegistry.VillagerProfession> getVillagerProfessions() {
        return ForgeRegistries.VILLAGER_PROFESSIONS.getValuesCollection();
    }

    public static List<VillagerRegistry.VillagerCareer> getVillagerCareers(VillagerRegistry.VillagerProfession profession) {
        ArrayList careers = Lists.newArrayList((Object[])new VillagerRegistry.VillagerCareer[]{profession.getCareer(0)});
        int i = 0;
        do {
            careers.add(profession.getCareer(++i));
        } while (!((VillagerRegistry.VillagerCareer)careers.get(0)).equals(careers.get(i)));
        careers.remove(profession.getCareer(i));
        return careers;
    }

    public static Optional<VillagerRegistry.VillagerProfession> getProfession(String profession) {
        for (VillagerRegistry.VillagerProfession p : VillagerHelper.getVillagerProfessions()) {
            if (p.getRegistryName() == null || !p.getRegistryName().toString().equalsIgnoreCase(profession) && !p.getRegistryName().toString().equalsIgnoreCase("minecraft:" + profession)) continue;
            return Optional.of(p);
        }
        return Optional.empty();
    }

    public static Optional<VillagerRegistry.VillagerCareer> getCareer(VillagerRegistry.VillagerProfession profession, String career) {
        return VillagerHelper.getVillagerCareers(profession).stream().filter(c -> c.getName().equalsIgnoreCase(career)).findAny();
    }

    public static Multimap<Integer, MerchantRecipe> getMerchantRecipes(VillagerRegistry.VillagerCareer career) {
        ArrayListMultimap recipeMultimap = ArrayListMultimap.create();
        int i = 1;
        while (career.getTrades(i) != null) {
            career.getTrades(i);
            ++i;
        }
        return recipeMultimap;
    }
}

