/*
 * Decompiled with CFR 0.152.
 */
package rocks.gameonthe.rockytweaks.crafttweaker.merchant;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseListAddition;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import java.util.List;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import rocks.gameonthe.rockytweaks.crafttweaker.merchant.MerchantTrade;
import rocks.gameonthe.rockytweaks.crafttweaker.merchant.VillagerHelper;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rockytweaks.Merchant")
@ZenRegister
public class MerchantTradeHandler {
    protected static final String name = "Merchant";
    private static final List<MerchantTrade> trades = Lists.newArrayList();

    @ZenMethod
    public static void addTrade(String profession, String career, IItemStack buy1, IItemStack buy2, IItemStack sell, int level) {
        Preconditions.checkNotNull((Object)profession, (Object)"Profession is required");
        Preconditions.checkArgument((boolean)VillagerHelper.getProfession(profession).isPresent(), (Object)"Profession not found");
        VillagerRegistry.VillagerProfession p1 = VillagerHelper.getProfession(profession).get();
        Preconditions.checkNotNull((Object)career, (Object)"Career is required");
        Preconditions.checkArgument((boolean)VillagerHelper.getCareer(p1, career).isPresent(), (Object)"Career not found");
        Preconditions.checkNotNull((Object)buy1, (Object)"Input is required");
        Preconditions.checkNotNull((Object)sell, (Object)"Output is required");
        Preconditions.checkArgument((level > 0 ? 1 : 0) != 0, (Object)"Level is required");
        CraftTweakerAPI.apply((IAction)new Add(new MerchantTrade(p1, VillagerHelper.getCareer(p1, career).get(), InputHelper.toStack((IItemStack)buy1), InputHelper.toStack((IItemStack)buy2), InputHelper.toStack((IItemStack)sell), level)));
    }

    @ZenMethod
    public static void addTrade(String profession, String career, IItemStack buy1, IItemStack sell, int level) {
        MerchantTradeHandler.addTrade(profession, career, buy1, null, sell, level);
    }

    private static class Add
    extends BaseListAddition<MerchantTrade> {
        public Add(MerchantTrade recipe) {
            super(MerchantTradeHandler.name, trades);
            this.recipes.add(recipe);
        }

        public void apply() {
            if (!this.recipes.isEmpty()) {
                for (MerchantTrade trade : this.recipes) {
                    if (trade != null) {
                        if (trades.add(trade)) {
                            this.successful.add(trade);
                            trade.register();
                            continue;
                        }
                        LogHelper.logError((String)String.format("Error adding %s Recipe for %s", this.name, this.getRecipeInfo(trade)));
                        continue;
                    }
                    LogHelper.logError((String)String.format("Error adding %s Recipe: null object", this.name));
                }
            }
        }

        public String getRecipeInfo(MerchantTrade trade) {
            return LogHelper.getStackDescription((Object)trade.getRecipe());
        }
    }
}

