/*
 * Decompiled with CFR 0.152.
 */
package rocks.gameonthe.rockytweaks.crafttweaker.merchant;

import com.blamejared.mtlib.helpers.StringHelper;
import com.google.common.collect.Lists;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.mc1120.commands.CraftTweakerCommand;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import org.apache.commons.lang3.text.StrBuilder;
import rocks.gameonthe.rockytweaks.crafttweaker.merchant.VillagerHelper;

public class MerchantCommand
extends CraftTweakerCommand {
    private final List<String> arguments = Lists.newArrayList((Object[])new String[]{"professions", "careers"});

    public MerchantCommand() {
        super("merchant");
        this.setDescription(new ITextComponent[]{new TextComponentString("Provides a list of valid merchant professions or careers")});
    }

    protected void init() {
    }

    public List<String> getSubSubCommand(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return this.arguments;
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length == 0 || !this.arguments.contains(args[0])) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Invalid arguments for command. Valid arguments: " + StringHelper.join(this.arguments, (String)", ")));
        } else if (args[0].equalsIgnoreCase("professions")) {
            StrBuilder builder = new StrBuilder("List of Merchant Professions:").appendNewLine();
            VillagerHelper.getVillagerProfessions().forEach(p -> builder.append((Object)p.getRegistryName()).appendNewLine());
            CraftTweakerAPI.logCommand((String)builder.build());
            sender.func_145747_a((ITextComponent)new TextComponentString("List generated; see crafttweaker.log in your minecraft dir."));
        } else if (args[0].equalsIgnoreCase("careers")) {
            StrBuilder builder = new StrBuilder("List of Merchant Careers:").appendNewLine();
            VillagerRegistry.VillagerProfession profession = null;
            if (args.length > 1) {
                if (VillagerHelper.getProfession(args[1]).isPresent()) {
                    profession = VillagerHelper.getProfession(args[1]).get();
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Invalid profession."));
                }
            }
            if (profession == null) {
                VillagerHelper.getVillagerProfessions().forEach(p -> {
                    builder.append((Object)p.getRegistryName()).appendNewLine();
                    VillagerHelper.getVillagerCareers(p).forEach(c -> builder.append(" - ").append(c.getName()).appendNewLine());
                });
            } else {
                builder.append((Object)profession.getRegistryName()).appendNewLine();
                VillagerHelper.getVillagerCareers(profession).forEach(c -> builder.append(" - ").append(c.getName()).appendNewLine());
            }
            CraftTweakerAPI.logCommand((String)builder.build());
            sender.func_145747_a((ITextComponent)new TextComponentString("List generated; see crafttweaker.log in your minecraft dir."));
        } else if (args[0].equalsIgnoreCase("trades")) {
            StrBuilder builder = new StrBuilder("List of Merchant Trades:").appendNewLine();
            VillagerRegistry.VillagerProfession profession = null;
            VillagerRegistry.VillagerCareer career = null;
            if (args.length > 1) {
                if (VillagerHelper.getProfession(args[1]).isPresent()) {
                    profession = VillagerHelper.getProfession(args[1]).get();
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Invalid profession."));
                }
                if (args.length > 2) {
                    if (VillagerHelper.getCareer(profession, args[2]).isPresent()) {
                        career = VillagerHelper.getCareer(profession, args[2]).get();
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Invalid career."));
                    }
                }
                if (profession == null) {
                    VillagerHelper.getVillagerProfessions().forEach(p -> VillagerHelper.getVillagerCareers(p).forEach(c -> {}));
                }
            }
            CraftTweakerAPI.logCommand((String)builder.build());
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("I can't even... (\u256f\u00b0\u25a1\u00b0\uff09\u256f\ufe35 \u253b\u2501\u253b"));
        }
    }
}

