/*
 * Decompiled with CFR 0.152.
 */
package rocks.gameonthe.rockytweaks.crafttweaker.anvil;

import com.blamejared.mtlib.helpers.InputHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.Comparator;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import rocks.gameonthe.rockytweaks.crafttweaker.anvil.AnvilRecipe;
import rocks.gameonthe.rockytweaks.crafttweaker.anvil.AnvilRecipeHandler;

public class AnvilListener {
    public AnvilListener() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        this.handleAnvilRemovals(event);
        this.handleAnvilAdditions(event);
    }

    private void handleAnvilAdditions(AnvilUpdateEvent event) {
        AnvilRecipe recipe = AnvilRecipeHandler.getRecipes().stream().filter(r -> r.isValid() && this.matches(r.getLeft(), event.getLeft()) && this.greaterThanOrEqual(r.getRight(), event.getRight())).max(Comparator.comparing(AnvilRecipe::getRightCount)).orElse(null);
        if (recipe != null) {
            event.setCanceled(false);
            event.setCost(recipe.getCost());
            event.setMaterialCost(recipe.getRightStack().func_190916_E());
            event.setOutput(this.getAnvilOutput(recipe, event));
        } else if (AnvilRecipeHandler.isRemoveAll()) {
            event.setCanceled(true);
        }
    }

    private void handleAnvilRemovals(AnvilUpdateEvent event) {
        if (AnvilRecipeHandler.getBlacklist().stream().anyMatch(r -> r.isBlacklisted(event.getLeft(), event.getRight(), event.getOutput()))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onAnvilCraft(AnvilRepairEvent event) {
        AnvilRecipeHandler.getRecipes().stream().filter(recipe -> recipe.isValid() && this.matches(recipe.getLeft(), event.getItemInput()) && this.greaterThanOrEqual(recipe.getRight(), event.getIngredientInput())).max(Comparator.comparing(AnvilRecipe::getRightCount)).ifPresent(recipe -> {
            if (event.getItemInput().func_190916_E() > recipe.getLeft().getAmount()) {
                ItemStack itemStack = event.getItemInput().func_77946_l();
                itemStack.func_190918_g(recipe.getLeft().getAmount());
                this.addToPlayerInventoryOrDrop(event.getEntityPlayer(), itemStack);
            }
            this.processInputTransform(event.getEntityPlayer(), event.getItemInput(), recipe.getLeft());
            this.processInputTransform(event.getEntityPlayer(), event.getIngredientInput(), recipe.getRight());
        });
    }

    private void processInputTransform(EntityPlayer player, ItemStack actual, IIngredient recipe) {
        if (recipe.hasNewTransformers()) {
            IItemStack transform = recipe.applyNewTransform(InputHelper.toIItemStack((ItemStack)actual));
            this.addToPlayerInventoryOrDrop(player, transform);
        }
    }

    private boolean matches(IIngredient iItemStack, ItemStack itemStack) {
        return iItemStack.matches(InputHelper.toIItemStack((ItemStack)itemStack));
    }

    private boolean greaterThanOrEqual(IIngredient iItemStack, ItemStack itemStack) {
        return this.matches(iItemStack.amount(itemStack.func_190916_E()), itemStack) && itemStack.func_190916_E() >= iItemStack.getAmount();
    }

    private ItemStack getAnvilOutput(AnvilRecipe recipe, AnvilUpdateEvent event) {
        if (recipe.getFunction() != null) {
            HashMap<String, IItemStack> inputs = new HashMap<String, IItemStack>();
            inputs.put("left", InputHelper.toIItemStack((ItemStack)event.getLeft()));
            inputs.put("right", InputHelper.toIItemStack((ItemStack)event.getRight()));
            IItemStack out = null;
            try {
                out = recipe.getFunction().process(recipe.getOutput(), inputs, null);
            }
            catch (Exception exception) {
                CraftTweakerAPI.logError((String)"Could not execute RecipeFunction: ", (Throwable)exception);
            }
            return InputHelper.toStack(out).func_77946_l();
        }
        return InputHelper.toStack((IItemStack)recipe.getOutput()).func_77946_l();
    }

    private void addToPlayerInventoryOrDrop(EntityPlayer player, ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return;
        }
        if (!player.field_71071_by.func_70441_a(itemStack = itemStack.func_77946_l())) {
            player.func_146097_a(itemStack, true, false);
        }
    }

    private void addToPlayerInventoryOrDrop(EntityPlayer player, IItemStack itemStack) {
        this.addToPlayerInventoryOrDrop(player, InputHelper.toStack((IItemStack)itemStack));
    }
}

