/*
 * Decompiled with CFR 0.152.
 */
package xt9.gamestagebooks.common.item;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.darkhax.gamestages.data.GameStageSaveHandler;
import net.darkhax.gamestages.data.IStageData;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import xt9.gamestagebooks.GamestageBooks;
import xt9.gamestagebooks.common.commands.Sender;
import xt9.gamestagebooks.common.item.ItemBase;
import xt9.gamestagebooks.common.network.UnlockGamestageMessage;

public class ItemStageBook
extends ItemBase {
    private String stageName;
    private String unlockItemName;
    private String stageHumanReadable;
    private int bookColor;

    public ItemStageBook(String stageName, String stageHumanReadable, String displayName, String unlockItemName, int bookColor) {
        super(stageName, 1, displayName);
        this.stageName = stageName;
        this.stageHumanReadable = stageHumanReadable;
        this.unlockItemName = unlockItemName == null ? "minecraft:book" : unlockItemName;
        this.bookColor = bookColor;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add("Read the book to unlock new knowledge.");
    }

    public ResourceLocation getModelLocation() {
        return new ResourceLocation("gamestagebooks", "books");
    }

    public int getColor() {
        return this.bookColor;
    }

    public String getUnlockItemName() {
        return this.unlockItemName;
    }

    public String getStageHumanReadable() {
        return this.stageHumanReadable;
    }

    public String getStageName() {
        return this.stageName;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        if (!player.field_70170_p.field_72995_K) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            playerMP.func_71121_q().func_152344_a(() -> this.unlockStageWithBook(player.func_184586_b(hand), playerMP));
        }
        return super.func_77659_a(worldIn, player, hand);
    }

    private void unlockStageWithBook(ItemStack book, EntityPlayerMP player) {
        ItemStageBook itemBook;
        IStageData data = GameStageSaveHandler.getPlayerData((UUID)player.func_110124_au());
        if (!data.hasStage((itemBook = (ItemStageBook)book.func_77973_b()).getStageName()) && player.func_184102_h() != null) {
            ICommandManager man = player.func_184102_h().func_71187_D();
            man.func_71556_a((ICommandSender)new Sender(player), "gamestage silentadd " + player.func_70005_c_() + " " + itemBook.getStageName());
            book.func_190918_g(1);
            GamestageBooks.network.sendTo((IMessage)new UnlockGamestageMessage(itemBook.getStageHumanReadable(), itemBook.getUnlockItemName()), player);
            player.func_71121_q().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187910_gj, SoundCategory.MASTER, 1.3f, 1.0f);
            player.func_71121_q().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187802_ec, SoundCategory.MASTER, 2.0f, 1.0f);
            player.func_71121_q().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187802_ec, SoundCategory.MASTER, 1.3f, -1.0f);
        } else {
            player.func_145747_a((ITextComponent)new TextComponentString("Already unlocked stage " + itemBook.getStageName() + "!"));
        }
    }
}

