/*
 * Decompiled with CFR 0.152.
 */
package xt9.gamestagebooks.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class UnlockPopup
extends GuiScreen {
    private FontRenderer fontRender;
    private Minecraft minecraft;
    private static String message = "";
    private static ItemStack messageItem;
    private static int ticksToRender;
    private long lastTick = 0L;

    public UnlockPopup(Minecraft mc) {
        this.minecraft = mc;
        this.fontRender = mc.field_71466_p;
        this.field_146296_j = this.minecraft.func_175599_af();
        this.func_183500_a(89, 12);
    }

    public static void handleMessage(String stageName, String itemName) {
        ticksToRender = 200;
        int metadata = 0;
        String[] parts = itemName.split("@");
        Item item = Item.func_111206_d((String)parts[0]);
        if (item == null) {
            item = Items.field_190931_a;
        }
        try {
            if (parts.length >= 2) {
                metadata = Integer.parseInt(parts[1]);
            }
        }
        catch (NumberFormatException e) {
            System.out.println("Not a valid number for meta or amount");
        }
        messageItem = new ItemStack(item, 1, metadata);
        message = "Unlocked " + stageName;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void renderOverlay(RenderGameOverlayEvent.Post event) {
        this.doTickChecks();
        if (event.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        if (!this.minecraft.field_71415_G) {
            return;
        }
        if (ticksToRender > 0) {
            this.renderMessage();
        }
    }

    private void renderMessage() {
        float itemScale = 2.7f;
        int itemX = this.getScreenCenterX(itemScale) - 8;
        this.drawItemStack(itemX, 10, messageItem, itemScale);
        float scale1 = 1.9f;
        float scale2 = 1.1f;
        int x1 = this.getScreenCenterX(scale1) - this.getHalfLineWidth(message, scale1);
        this.renderScaledStringWithColor(scale1, x1, 74, message, 0xFFFFFF);
        String line2 = "You ponder the contents of the book";
        int x2 = this.getScreenCenterX(scale2) - this.getHalfLineWidth(line2, scale2);
        this.renderScaledString(scale2, x2, 92, line2);
        String line3 = "And you find yourself enlightened";
        int x3 = this.getScreenCenterX(scale2) - this.getHalfLineWidth(line3, scale2);
        this.renderScaledString(scale2, x3, 104, line3);
    }

    private void doTickChecks() {
        if (this.lastTick != this.minecraft.field_71441_e.func_82737_E()) {
            this.lastTick = this.minecraft.field_71441_e.func_82737_E();
            if (ticksToRender > 0) {
                --ticksToRender;
            }
        }
    }

    private void renderScaledStringWithColor(float scale, int x, int y, String text, int color) {
        GL11.glPushMatrix();
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        this.func_73731_b(this.fontRender, text, x, (int)((float)y / scale), color);
        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    private void renderScaledString(float scale, int x, int y, String text) {
        this.renderScaledStringWithColor(scale, x, y, text, 0xFFFFFF);
    }

    private int getItemHalfWidth(float glScale) {
        return (int)(8.0f * glScale / glScale);
    }

    private int getHalfLineWidth(String text, float glScale) {
        return (int)((float)(this.fontRender.func_78256_a(text) / 2) * glScale / glScale);
    }

    private int getScreenCenterX() {
        ScaledResolution scaledResolution = new ScaledResolution(this.minecraft);
        return scaledResolution.func_78326_a() / 2;
    }

    private int getScreenCenterX(float glScale) {
        ScaledResolution scaledResolution = new ScaledResolution(this.minecraft);
        return (int)((float)(scaledResolution.func_78326_a() / 2) / glScale);
    }

    private int getLeftCornerX() {
        return 5;
    }

    private int getRightCornerX() {
        ScaledResolution scaledResolution = new ScaledResolution(this.minecraft);
        return scaledResolution.func_78326_a() - this.field_146294_l - 5;
    }

    private void drawItemStack(int x, int y, ItemStack stack, float scale) {
        if (messageItem == null) {
            messageItem = new ItemStack(Items.field_190931_a, 1, 0);
        }
        RenderHelper.func_74520_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        GL11.glPushMatrix();
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        if (messageItem != null) {
            this.field_146296_j.func_180450_b(stack, x, y);
        }
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        RenderHelper.func_74518_a();
    }

    static {
        ticksToRender = 0;
    }
}

