/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.morelootstuff.loot.conditions.gamestages;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HasAnyOfStages
implements LootCondition {
    private static final ResourceLocation ID = new ResourceLocation("morelootstuff", "has_any_of_stages");
    private static final Logger LOGGER = LogManager.getLogger((String)ID.toString());
    private final List<String> stages;

    public HasAnyOfStages(Iterable<String> stages) {
        this.stages = Lists.newArrayList(stages);
    }

    public boolean func_186618_a(Random rand, LootContext context) {
        if (context.func_186495_b() == null) {
            LOGGER.debug("No player provided by LootContext. Unable to determine granted stages, returning false.");
            return false;
        }
        return GameStageHelper.hasAnyOf((EntityPlayer)((EntityPlayer)context.func_186495_b()), this.stages);
    }

    public static class Serialiser
    extends LootCondition.Serializer<HasAnyOfStages> {
        public Serialiser() {
            super(ID, HasAnyOfStages.class);
        }

        public void serialize(JsonObject json, HasAnyOfStages value, JsonSerializationContext context) {
            JsonArray stageArray = new JsonArray();
            for (String stage : value.stages) {
                stageArray.add(stage);
            }
            json.add("stages", (JsonElement)stageArray);
        }

        public HasAnyOfStages deserialize(JsonObject json, JsonDeserializationContext context) {
            Collection stages = Streams.stream((Iterable)JsonUtils.func_151214_t((JsonObject)json, (String)"stages")).map(je -> JsonUtils.func_151206_a((JsonElement)je, (String)"stage")).collect(Collectors.toList());
            return new HasAnyOfStages(stages);
        }
    }
}

