/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.morelootstuff.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.common.util.FakePlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KilledByRealPlayer
implements LootCondition {
    private static final ResourceLocation ID = new ResourceLocation("morelootstuff", "killed_by_real_player");
    private static final Logger LOGGER = LogManager.getLogger((String)ID.toString());
    private final boolean inverse;

    public KilledByRealPlayer(boolean inverse) {
        this.inverse = inverse;
    }

    public boolean func_186618_a(Random rand, LootContext context) {
        if (context.func_186495_b() == null) {
            LOGGER.debug("No player provided by LootContext. Unable to determine killer type, returning false.");
        }
        boolean killerIsPlayer = context.func_186495_b() instanceof EntityPlayer;
        boolean isFake = context.func_186495_b() instanceof FakePlayer;
        return killerIsPlayer && (this.inverse ? isFake : !isFake);
    }

    public static class Serialiser
    extends LootCondition.Serializer<KilledByRealPlayer> {
        public Serialiser() {
            super(ID, KilledByRealPlayer.class);
        }

        public void serialize(JsonObject json, KilledByRealPlayer value, JsonSerializationContext context) {
            json.addProperty("inverse", Boolean.valueOf(value.inverse));
        }

        public KilledByRealPlayer deserialize(JsonObject json, JsonDeserializationContext context) {
            return new KilledByRealPlayer(JsonUtils.func_151209_a((JsonObject)json, (String)"inverse", (boolean)false));
        }
    }
}

