/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.morelootstuff.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import leviathan143.morelootstuff.loot.TargetSelector;
import net.minecraft.entity.Entity;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InDimension
implements LootCondition {
    private static final ResourceLocation ID = new ResourceLocation("morelootstuff", "in_dimension");
    private static final Logger LOGGER = LogManager.getLogger((String)ID.toString());
    private final int dimensionId;
    public TargetSelector targetSelector;

    public InDimension(int dimensionId, TargetSelector targetSelector) {
        this.dimensionId = dimensionId;
        this.targetSelector = targetSelector;
    }

    public boolean func_186618_a(Random rand, LootContext context) {
        Entity reference = this.targetSelector.get(context);
        if (reference == null) {
            LOGGER.debug("LootContext has no {}. Unable to determine dimension, returning false.", (Object)this.targetSelector);
            return false;
        }
        return reference.func_130014_f_().field_73011_w.getDimension() == this.dimensionId;
    }

    public static class Serialiser
    extends LootCondition.Serializer<InDimension> {
        public Serialiser() {
            super(ID, InDimension.class);
        }

        public void serialize(JsonObject json, InDimension condition, JsonSerializationContext context) {
            json.addProperty("dimID", (Number)condition.dimensionId);
            json.add("target", condition.targetSelector.toJson());
        }

        public InDimension deserialize(JsonObject json, JsonDeserializationContext context) {
            TargetSelector targetSelector = json.has("target") ? TargetSelector.fromJson(json, "target") : TargetSelector.OLD_BEHAVIOUR;
            return new InDimension(JsonUtils.func_151203_m((JsonObject)json, (String)"dimID"), targetSelector);
        }
    }
}

