/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.morelootstuff.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import leviathan143.morelootstuff.loot.TargetSelector;
import net.minecraft.entity.Entity;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InBounds
implements LootCondition {
    private static final ResourceLocation ID = new ResourceLocation("morelootstuff", "in_bounds");
    private static final Logger LOGGER = LogManager.getLogger((String)ID.toString());
    private static final int WORLD_SIZE = 30000000;
    private final int minX;
    private final int minY;
    private final int minZ;
    private final int maxX;
    private final int maxY;
    private final int maxZ;
    private final TargetSelector targetSelector;

    public InBounds(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, TargetSelector targetSelector) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        this.targetSelector = targetSelector;
    }

    public boolean func_186618_a(Random rand, LootContext context) {
        Entity reference = this.targetSelector.get(context);
        if (reference == null) {
            LOGGER.debug("LootContext has no {}. Unable to determine position, returning false.", (Object)this.targetSelector);
            return false;
        }
        return reference.field_70165_t >= (double)this.minX && reference.field_70165_t <= (double)this.maxX && reference.field_70163_u >= (double)this.minY && reference.field_70163_u <= (double)this.maxY && reference.field_70161_v >= (double)this.minZ && reference.field_70161_v <= (double)this.maxZ;
    }

    public static class Serialiser
    extends LootCondition.Serializer<InBounds> {
        public Serialiser() {
            super(ID, InBounds.class);
        }

        public void serialize(JsonObject json, InBounds condition, JsonSerializationContext context) {
            json.addProperty("minX", (Number)condition.minX);
            json.addProperty("minY", (Number)condition.minY);
            json.addProperty("minZ", (Number)condition.minZ);
            json.addProperty("maxX", (Number)condition.maxX);
            json.addProperty("maxY", (Number)condition.maxY);
            json.addProperty("maxZ", (Number)condition.maxZ);
            json.add("target", condition.targetSelector.toJson());
        }

        public InBounds deserialize(JsonObject json, JsonDeserializationContext context) {
            int minX = JsonUtils.func_151208_a((JsonObject)json, (String)"minX", (int)-30000000);
            int minY = JsonUtils.func_151208_a((JsonObject)json, (String)"minY", (int)0);
            int minZ = JsonUtils.func_151208_a((JsonObject)json, (String)"minZ", (int)-30000000);
            int maxX = JsonUtils.func_151208_a((JsonObject)json, (String)"maxX", (int)30000000);
            int maxY = JsonUtils.func_151208_a((JsonObject)json, (String)"maxY", (int)255);
            int maxZ = JsonUtils.func_151208_a((JsonObject)json, (String)"maxZ", (int)30000000);
            TargetSelector targetSelector = json.has("target") ? TargetSelector.fromJson(json, "target") : TargetSelector.OLD_BEHAVIOUR;
            return new InBounds(minX, minY, minZ, maxX, maxY, maxZ, targetSelector);
        }
    }
}

