/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.morelootstuff.loot.conditions;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import leviathan143.morelootstuff.CommonReflection;
import leviathan143.morelootstuff.loot.TargetSelector;
import net.minecraft.entity.Entity;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InBiomeOfType
implements LootCondition {
    private static final ResourceLocation ID = new ResourceLocation("morelootstuff", "in_biome_of_type");
    private static final Logger LOGGER = LogManager.getLogger((String)ID.toString());
    private final List<BiomeDictionary.Type> targetBiomeTypes;
    private final TargetSelector targetSelector;

    public InBiomeOfType(Iterable<BiomeDictionary.Type> targetBiomeTypes, TargetSelector targetSelector) {
        this.targetBiomeTypes = Lists.newArrayList(targetBiomeTypes);
        this.targetSelector = targetSelector;
    }

    public boolean func_186618_a(Random rand, LootContext context) {
        Entity reference = this.targetSelector.get(context);
        if (reference == null) {
            LOGGER.debug("LootContext has no {}. Unable to determine biome type, returning false.", (Object)this.targetSelector);
            return false;
        }
        Biome biome = context.getWorld().func_180494_b(reference.func_180425_c());
        for (BiomeDictionary.Type type : this.targetBiomeTypes) {
            if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)type)) continue;
            return true;
        }
        return false;
    }

    public static class Serialiser
    extends LootCondition.Serializer<InBiomeOfType> {
        public Serialiser() {
            super(ID, InBiomeOfType.class);
        }

        public void serialize(JsonObject json, InBiomeOfType condition, JsonSerializationContext context) {
            JsonArray typeNameArray = new JsonArray();
            for (BiomeDictionary.Type biomeType : condition.targetBiomeTypes) {
                typeNameArray.add(biomeType.getName());
            }
            json.add("types", (JsonElement)typeNameArray);
            json.add("target", condition.targetSelector.toJson());
        }

        public InBiomeOfType deserialize(JsonObject json, JsonDeserializationContext context) {
            Map<String, BiomeDictionary.Type> typeMap = CommonReflection.getTypeMap();
            JsonArray biomeTypeIDs = JsonUtils.func_151214_t((JsonObject)json, (String)"types");
            ArrayList<BiomeDictionary.Type> types = new ArrayList<BiomeDictionary.Type>();
            for (JsonElement typeID : biomeTypeIDs) {
                BiomeDictionary.Type biomeType = typeMap.get(JsonUtils.func_151206_a((JsonElement)typeID, (String)"biome type"));
                if (biomeType == null) {
                    LOGGER.error("Unknown biome type '{}'", (Object)typeID);
                    continue;
                }
                types.add(biomeType);
            }
            TargetSelector targetSelector = json.has("target") ? TargetSelector.fromJson(json, "target") : TargetSelector.OLD_BEHAVIOUR;
            return new InBiomeOfType(types, targetSelector);
        }
    }
}

