/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.morelootstuff.loot.conditions;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import leviathan143.morelootstuff.loot.TargetSelector;
import net.minecraft.entity.Entity;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InBiome
implements LootCondition {
    private static final ResourceLocation ID = new ResourceLocation("morelootstuff", "in_biome");
    private static final Logger LOGGER = LogManager.getLogger((String)ID.toString());
    private final List<Biome> targetBiomes;
    private final TargetSelector targetSelector;

    public InBiome(Iterable<Biome> targetBiomes, TargetSelector targetSelector) {
        this.targetBiomes = Lists.newArrayList(targetBiomes);
        this.targetSelector = targetSelector;
    }

    public boolean func_186618_a(Random rand, LootContext context) {
        Entity reference = this.targetSelector.get(context);
        if (reference == null) {
            LOGGER.debug("LootContext has no {}. Unable to determine biome, returning false.", (Object)this.targetSelector);
            return false;
        }
        Biome biome = context.getWorld().func_180494_b(reference.func_180425_c());
        return this.targetBiomes.contains(biome);
    }

    public static class Serialiser
    extends LootCondition.Serializer<InBiome> {
        public Serialiser() {
            super(ID, InBiome.class);
        }

        public void serialize(JsonObject json, InBiome condition, JsonSerializationContext context) {
            JsonArray biomeNameArray = new JsonArray();
            for (Biome biome : condition.targetBiomes) {
                biomeNameArray.add(biome.getRegistryName().toString());
            }
            json.add("biomes", (JsonElement)biomeNameArray);
            json.add("target", condition.targetSelector.toJson());
        }

        public InBiome deserialize(JsonObject json, JsonDeserializationContext context) {
            JsonArray biomeIDs = JsonUtils.func_151214_t((JsonObject)json, (String)"biomes");
            ArrayList<Biome> biomes = new ArrayList<Biome>();
            for (JsonElement biomeID : biomeIDs) {
                Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(JsonUtils.func_151206_a((JsonElement)biomeID, (String)"biome id")));
                if (biome == null) {
                    LOGGER.error("Unknown biome type '{}'", (Object)biomeID);
                    continue;
                }
                biomes.add(biome);
            }
            TargetSelector targetSelector = json.has("target") ? TargetSelector.fromJson(json, "target") : TargetSelector.OLD_BEHAVIOUR;
            return new InBiome(biomes, targetSelector);
        }
    }
}

