/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.morelootstuff.loot;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.util.JsonUtils;
import net.minecraft.world.storage.loot.LootContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum TargetSelector {
    PLAYER("player", LootContext.EntityTarget.KILLER_PLAYER),
    KILLER("killer", LootContext.EntityTarget.KILLER),
    LOOTED_ENTITY("looted_entity", LootContext.EntityTarget.THIS),
    OLD_BEHAVIOUR("old_behaviour", null){

        @Override
        public Entity get(LootContext context) {
            Entity entity = context.func_186493_a();
            if (entity == null) {
                LOGGER.debug("No looted entity provided by LootContext, falling back to player.");
                entity = context.func_186495_b();
            }
            if (entity == null) {
                LOGGER.debug("No player provided by LootContext. Unable to determine biome type, returning false.");
            }
            return entity;
        }
    };

    private static final Logger LOGGER;
    private static final Map<String, TargetSelector> TARGET_BY_ID;
    private final String id;
    private final LootContext.EntityTarget delegate;

    private TargetSelector(String id, LootContext.EntityTarget delegate) {
        this.id = id;
        this.delegate = delegate;
    }

    public static TargetSelector fromId(String id) {
        TargetSelector target = TARGET_BY_ID.get(id);
        if (target == null) {
            throw new IllegalArgumentException("Unknown target " + id);
        }
        return target;
    }

    public static TargetSelector fromJson(JsonObject json, String key) {
        try {
            return TargetSelector.fromId(JsonUtils.func_151200_h((JsonObject)json, (String)key));
        }
        catch (IllegalArgumentException iae) {
            throw new JsonSyntaxException(iae.getMessage());
        }
    }

    public JsonElement toJson() {
        return new JsonPrimitive(this.id);
    }

    public Entity get(LootContext context) {
        return context.func_186494_a(this.delegate);
    }

    public String toString() {
        return this.id;
    }

    static {
        LOGGER = LogManager.getLogger((String)"morelootstuff");
        TARGET_BY_ID = Arrays.stream(TargetSelector.values()).collect(Collectors.toMap(t -> t.id, t -> t));
    }
}

