/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod;

import ewewukek.musketmod.BulletEntity;
import ewewukek.musketmod.MusketItem;
import ewewukek.musketmod.MusketMod;
import ewewukek.musketmod.PistolItem;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.util.Locale;
import java.util.Scanner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Config {
    private static final Logger logger = LogManager.getLogger(MusketMod.class);
    public static final Config INSTANCE = new Config();
    public static final int VERSION = 2;
    public double bulletMaxDistance;
    public double bulletStdDev;
    public double bulletSpeed;
    public double damageMin;
    public double damageMax;
    public double pistolBulletStdDev;
    public double pistolBulletSpeed;
    public double pistolDamageMin;
    public double pistolDamageMax;

    public static void reload() {
        INSTANCE.setDefaults();
        INSTANCE.load();
        BulletEntity.maxDistance = Config.INSTANCE.bulletMaxDistance;
        MusketItem.bulletStdDev = (float)Math.toRadians(Config.INSTANCE.bulletStdDev);
        MusketItem.bulletSpeed = (float)(Config.INSTANCE.bulletSpeed / 20.0);
        double maxEnergy = MusketItem.bulletSpeed * MusketItem.bulletSpeed;
        MusketItem.damageMultiplierMin = (float)(Config.INSTANCE.damageMin / maxEnergy);
        MusketItem.damageMultiplierMax = (float)(Config.INSTANCE.damageMax / maxEnergy);
        PistolItem.bulletStdDev = (float)Math.toRadians(Config.INSTANCE.pistolBulletStdDev);
        PistolItem.bulletSpeed = (float)(Config.INSTANCE.pistolBulletSpeed / 20.0);
        maxEnergy = PistolItem.bulletSpeed * PistolItem.bulletSpeed;
        PistolItem.damageMultiplierMin = (float)(Config.INSTANCE.pistolDamageMin / maxEnergy);
        PistolItem.damageMultiplierMax = (float)(Config.INSTANCE.pistolDamageMax / maxEnergy);
        logger.info("Configuration has been loaded");
    }

    private void setDefaults() {
        this.bulletMaxDistance = 256.0;
        this.bulletStdDev = 1.0;
        this.bulletSpeed = 180.0;
        this.damageMin = 20.5;
        this.damageMax = 21.0;
        this.pistolBulletStdDev = 1.5;
        this.pistolBulletSpeed = 140.0;
        this.pistolDamageMin = 12.0;
        this.pistolDamageMax = 12.5;
    }

    /*
     * Unable to fully structure code
     */
    private void load() {
        version = 0;
        try {
            reader = Files.newBufferedReader(MusketMod.CONFIG_PATH);
            try {
                lineNumber = 0;
lbl6:
                // 16 sources

                block39: while ((line = reader.readLine()) != null) {
                    ++lineNumber;
                    commentStart = line.indexOf(35);
                    if (commentStart != -1) {
                        line = line.substring(0, commentStart);
                    }
                    line.trim();
                    if (line.length() == 0) continue;
                    errorPrefix = MusketMod.CONFIG_PATH + ": line " + lineNumber + ": ";
                    s = new Scanner(line);
                    try {
                        s.useLocale(Locale.US);
                        s.useDelimiter("\\s*=\\s*");
                        if (!s.hasNext()) {
                            Config.logger.warn(errorPrefix + "parameter name is missing");
                            continue;
                        }
                        key = s.next().trim();
                        if (!s.hasNextDouble()) {
                            Config.logger.warn(errorPrefix + "value is missing/wrong/not a number");
                            continue;
                        }
                        value = s.nextDouble();
                        var11_16 = key;
                        var12_17 = -1;
                        switch (var11_16.hashCode()) {
                            case 351608024: {
                                if (!var11_16.equals("version")) break;
                                var12_17 = 0;
                                break;
                            }
                            case -1363058921: {
                                if (!var11_16.equals("bulletMaxDistance")) break;
                                var12_17 = 1;
                                break;
                            }
                            case 582909588: {
                                if (!var11_16.equals("bulletStdDev")) break;
                                var12_17 = 2;
                                break;
                            }
                            case -1366786971: {
                                if (!var11_16.equals("bulletSpeed")) break;
                                var12_17 = 3;
                                break;
                            }
                            case 2020948067: {
                                if (!var11_16.equals("damageMin")) break;
                                var12_17 = 4;
                                break;
                            }
                            case 2020947829: {
                                if (!var11_16.equals("damageMax")) break;
                                var12_17 = 5;
                                break;
                            }
                            case -596850261: {
                                if (!var11_16.equals("pistolBulletStdDev")) break;
                                var12_17 = 6;
                                break;
                            }
                            case 1089008238: {
                                if (!var11_16.equals("pistolBulletSpeed")) break;
                                var12_17 = 7;
                                break;
                            }
                            case 593337516: {
                                if (!var11_16.equals("pistolDamageMin")) break;
                                var12_17 = 8;
                                break;
                            }
                            case 593337278: {
                                if (!var11_16.equals("pistolDamageMax")) break;
                                var12_17 = 9;
                            }
                        }
                        switch (var12_17) {
                            case 0: {
                                version = (int)value;
                                ** break;
                            }
                            case 1: {
                                this.bulletMaxDistance = value;
                                ** break;
                            }
                            case 2: {
                                this.bulletStdDev = value;
                                ** break;
                            }
                            case 3: {
                                this.bulletSpeed = value;
                                ** break;
                            }
                            case 4: {
                                this.damageMin = value;
                                ** break;
                            }
                            case 5: {
                                this.damageMax = value;
                                ** break;
                            }
                            case 6: {
                                this.pistolBulletStdDev = value;
                                ** break;
                            }
                            case 7: {
                                this.pistolBulletSpeed = value;
                                ** break;
                            }
                            case 8: {
                                this.pistolDamageMin = value;
                                ** break;
                            }
                            case 9: {
                                this.pistolDamageMax = value;
                                ** break;
                            }
                            default: {
                                Config.logger.warn(errorPrefix + "unrecognized parameter name: " + key);
                                continue block39;
                            }
                        }
                    }
                    finally {
                        s.close();
                    }
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (NoSuchFileException e) {
            this.save();
            Config.logger.info("Configuration file not found, default created");
        }
        catch (IOException e) {
            Config.logger.warn("Could not read configuration file: ", (Throwable)e);
        }
        if (version < 2) {
            Config.logger.info("Configuration file belongs to older version, updating");
            if (version < 2 && this.damageMax == 21.5) {
                this.damageMax = 21.0;
            }
            this.save();
        }
    }

    private void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(MusketMod.CONFIG_PATH, new OpenOption[0]);){
            writer.write("version = 2\n");
            writer.write("\n");
            writer.write("# Maximum bullet travel distance (in blocks)\n");
            writer.write("bulletMaxDistance = " + this.bulletMaxDistance + "\n");
            writer.write("\n");
            writer.write("# Musket\n");
            writer.write("\n");
            writer.write("# Standard deviation of bullet spread (in degrees)\n");
            writer.write("bulletStdDev = " + this.bulletStdDev + "\n");
            writer.write("# Muzzle velocity of bullet (in blocks per second)\n");
            writer.write("bulletSpeed = " + this.bulletSpeed + "\n");
            writer.write("# Minimum damage at point-blank range\n");
            writer.write("damageMin = " + this.damageMin + "\n");
            writer.write("# Maximum damage at point-blank range\n");
            writer.write("damageMax = " + this.damageMax + "\n");
            writer.write("\n");
            writer.write("# Pistol\n");
            writer.write("\n");
            writer.write("# Standard deviation of bullet spread (in degrees)\n");
            writer.write("pistolBulletStdDev = " + this.pistolBulletStdDev + "\n");
            writer.write("# Muzzle velocity of bullet (in blocks per second)\n");
            writer.write("pistolBulletSpeed = " + this.pistolBulletSpeed + "\n");
            writer.write("# Minimum damage at point-blank range\n");
            writer.write("pistolDamageMin = " + this.pistolDamageMin + "\n");
            writer.write("# Maximum damage at point-blank range\n");
            writer.write("pistolDamageMax = " + this.pistolDamageMax + "\n");
        }
        catch (IOException e) {
            logger.warn("Could not save configuration file: ", (Throwable)e);
        }
    }
}

