/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import ewewukek.musketmod.GunItem;
import ewewukek.musketmod.Items;
import java.util.Optional;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class ClientUtilities {
    public static boolean disableMainHandEquipAnimation;
    public static boolean disableOffhandEquipAnimation;

    public static Optional<HumanoidModel.ArmPose> getArmPose(Player player, InteractionHand hand) {
        GunItem gunItem;
        ItemStack stack = player.m_21120_(hand);
        if (!player.f_20911_ && !stack.m_41619_() && stack.m_41720_() instanceof GunItem && (gunItem = (GunItem)stack.m_41720_()).canUseFrom(player, hand) && GunItem.isLoaded(stack)) {
            return Optional.of(HumanoidModel.ArmPose.CROSSBOW_HOLD);
        }
        return Optional.empty();
    }

    public static void renderGunInHand(ItemInHandRenderer renderer, AbstractClientPlayer player, InteractionHand hand, float partialTicks, float interpolatedPitch, float swingProgress, float equipProgress, ItemStack stack, PoseStack matrixStack, MultiBufferSource render, int packedLight) {
        HumanoidArm handside = hand == InteractionHand.MAIN_HAND ? player.m_5737_() : player.m_5737_().m_20828_();
        boolean isRightHand = handside == HumanoidArm.RIGHT;
        float sign = isRightHand ? 1.0f : -1.0f;
        GunItem gunItem = (GunItem)stack.m_41720_();
        if (!gunItem.canUseFrom((Player)player, hand)) {
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)sign * 0.5, -0.5 - 0.6 * (double)equipProgress, -0.7);
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(70.0f));
            renderer.m_269530_((LivingEntity)player, stack, isRightHand ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND, !isRightHand, matrixStack, render, packedLight);
            matrixStack.m_85849_();
            return;
        }
        if (stack == GunItem.getActiveStack(hand)) {
            ClientUtilities.setEquipAnimationDisabled(hand, true);
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)sign * 0.15, -0.25, -0.35);
        if (swingProgress > 0.0f) {
            float swingSharp = Mth.m_14031_((float)(Mth.m_14116_((float)swingProgress) * (float)Math.PI));
            float swingNormal = Mth.m_14031_((float)(swingProgress * (float)Math.PI));
            if (gunItem == Items.MUSKET_WITH_BAYONET) {
                matrixStack.m_85837_((double)sign * -0.05 * (double)swingNormal, 0.0, 0.05 - 0.3 * (double)swingSharp);
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(5.0f * swingSharp));
            } else {
                matrixStack.m_85837_((double)sign * 0.05 * (double)(1.0f - swingNormal), 0.05 * (double)(1.0f - swingNormal), 0.05 - 0.4 * (double)swingSharp);
                matrixStack.m_252781_(Axis.f_252529_.m_252977_(180.0f + sign * 20.0f * (1.0f - swingSharp)));
            }
        } else if (player.m_6117_() && player.m_7655_() == hand) {
            float usingDuration = (float)stack.m_41779_() - ((float)player.m_21212_() - partialTicks + 1.0f);
            if (usingDuration > 0.0f && usingDuration < 30.0f) {
                matrixStack.m_85837_(0.0, -0.3, 0.05);
                matrixStack.m_252781_(Axis.f_252529_.m_252977_(60.0f));
                matrixStack.m_252781_(Axis.f_252403_.m_252977_(10.0f));
                if (usingDuration >= 8.0f && usingDuration <= 14.0f || usingDuration >= 18.0f && usingDuration <= 24.0f) {
                    float t;
                    if (usingDuration >= 18.0f) {
                        usingDuration -= 10.0f;
                    }
                    if (usingDuration < 10.0f) {
                        t = (usingDuration - 8.0f) / 2.0f;
                        t = Mth.m_14031_((float)(1.5707964f * Mth.m_14116_((float)t)));
                    } else {
                        t = (14.0f - usingDuration) / 4.0f;
                    }
                    matrixStack.m_85837_(0.0, 0.0, 0.025 * (double)t);
                }
                if (gunItem == Items.PISTOL) {
                    matrixStack.m_85837_(0.0, 0.0, -0.12);
                }
            }
        } else if (ClientUtilities.isEquipAnimationDisabled(hand)) {
            if (equipProgress == 0.0f) {
                ClientUtilities.setEquipAnimationDisabled(hand, false);
            }
        } else {
            matrixStack.m_85837_(0.0, -0.6 * (double)equipProgress, 0.0);
        }
        renderer.m_269530_((LivingEntity)player, stack, isRightHand ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND, !isRightHand, matrixStack, render, packedLight);
        matrixStack.m_85849_();
    }

    public static boolean isEquipAnimationDisabled(InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            return disableMainHandEquipAnimation;
        }
        return disableOffhandEquipAnimation;
    }

    public static void setEquipAnimationDisabled(InteractionHand hand, boolean disabled) {
        if (hand == InteractionHand.MAIN_HAND) {
            disableMainHandEquipAnimation = disabled;
        } else {
            disableOffhandEquipAnimation = disabled;
        }
    }
}

