/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod;

import ewewukek.musketmod.MusketMod;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BulletEntity
extends AbstractHurtingProjectile {
    public static final EntityDataAccessor<Float> INITIAL_SPEED = SynchedEntityData.m_135353_(BulletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final double MIN_DAMAGE = 0.5;
    public static final double GRAVITY = 0.05;
    public static final double AIR_FRICTION = 0.99;
    public static final double WATER_FRICTION = 0.6;
    public static final short LIFETIME = 50;
    public static double maxDistance;
    public float damageMultiplier;
    public boolean ignoreInvulnerableTime;
    public float distanceTravelled;
    public short tickCounter;
    public static final ResourceKey<DamageType> MUSKET;

    public BulletEntity(EntityType<BulletEntity> entityType, Level world) {
        super(entityType, world);
    }

    public BulletEntity(Level world) {
        this(MusketMod.BULLET_ENTITY_TYPE, world);
    }

    public boolean isFirstTick() {
        return this.tickCounter == 0;
    }

    public DamageSource causeMusketDamage(BulletEntity bullet, Entity attacker) {
        return this.m_9236_().m_269111_().m_268998_(MUSKET, (Entity)bullet, attacker);
    }

    public void discardOnNextTick() {
        this.tickCounter = (short)50;
    }

    public void m_8119_() {
        Vec3 pos;
        BlockHitResult fluidHitResult;
        EntityHitResult entityHitResult;
        BlockHitResult hitResult;
        this.tickCounter = (short)(this.tickCounter + 1);
        if (this.tickCounter >= 50 || (double)this.distanceTravelled > maxDistance) {
            this.m_146870_();
            return;
        }
        Vec3 motion = this.m_20184_();
        Vec3 from = this.m_20182_();
        Vec3 to = from.m_82549_(motion);
        Vec3 waterPos = from;
        this.f_19798_ = this.m_204031_(FluidTags.f_13131_, 0.0);
        if (this.f_19798_) {
            motion = motion.m_82490_(0.6);
            to = from.m_82549_(motion);
            this.m_20256_(motion);
        }
        if ((hitResult = this.m_9236_().m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this))).m_6662_() != HitResult.Type.MISS) {
            to = hitResult.m_82450_();
        }
        if ((entityHitResult = this.findHitEntity(from, to)) != null) {
            hitResult = entityHitResult;
            to = hitResult.m_82450_();
        }
        if (!this.f_19798_ && (fluidHitResult = this.m_9236_().m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this))).m_6662_() == HitResult.Type.BLOCK) {
            FluidState fluid = this.m_9236_().m_6425_(fluidHitResult.m_82425_());
            double distanceToFluid = fluidHitResult.m_82450_().m_82546_(from).m_82553_();
            double distanceToHit = to.m_82546_(from).m_82553_();
            if (fluid.m_205070_(FluidTags.f_13131_)) {
                int impactParticleCount;
                this.f_19798_ = true;
                waterPos = fluidHitResult.m_82450_();
                double velocity = motion.m_82553_();
                double timeInWater = 1.0 - distanceToFluid / velocity;
                double newVelocity = velocity * (1.0 - timeInWater + timeInWater * Math.pow(0.6, timeInWater));
                if (hitResult.m_6662_() != HitResult.Type.MISS) {
                    if (distanceToFluid < distanceToHit) {
                        if (distanceToHit < newVelocity) {
                            timeInWater = (distanceToHit - distanceToFluid) / velocity;
                            newVelocity = velocity * (1.0 - timeInWater + timeInWater * Math.pow(0.6, timeInWater));
                        } else {
                            hitResult = BlockHitResult.m_82426_(null, null, null);
                        }
                    } else {
                        fluidHitResult = BlockHitResult.m_82426_(null, null, null);
                    }
                }
                motion = motion.m_82490_(newVelocity / velocity);
                to = from.m_82549_(motion);
                this.m_20256_(motion);
                if (fluidHitResult.m_6662_() != HitResult.Type.MISS && (impactParticleCount = (int)(this.m_20184_().m_82556_() / 10.0)) > 0) {
                    Vec3 pos2 = fluidHitResult.m_82450_();
                    double yv = fluidHitResult.m_82434_() == Direction.UP ? 0.02 : 0.0;
                    for (int i = 0; i < impactParticleCount; ++i) {
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, pos2.f_82479_, pos2.f_82480_, pos2.f_82481_, this.f_19796_.m_188583_() * 0.01, this.f_19796_.m_188583_() * 0.01 + yv, this.f_19796_.m_188583_() * 0.01);
                    }
                }
            } else if (fluid.m_205070_(FluidTags.f_13132_) && (hitResult.m_6662_() == HitResult.Type.MISS || distanceToFluid < distanceToHit)) {
                hitResult = fluidHitResult;
                to = fluidHitResult.m_82450_();
            }
        }
        if (hitResult.m_6662_() != HitResult.Type.MISS) {
            if (!this.m_9236_().f_46443_) {
                this.m_6532_((HitResult)hitResult);
                this.discardOnNextTick();
            } else if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                int impactParticleCount = (int)(this.m_20184_().m_82556_() / 20.0);
                if (impactParticleCount > 0) {
                    BlockState blockstate = this.m_9236_().m_8055_(hitResult.m_82425_());
                    BlockParticleOption particleOption = new BlockParticleOption(ParticleTypes.f_123794_, blockstate);
                    pos = hitResult.m_82450_();
                    for (int i = 0; i < impactParticleCount; ++i) {
                        this.m_9236_().m_7106_((ParticleOptions)particleOption, pos.f_82479_, pos.f_82480_, pos.f_82481_, this.f_19796_.m_188583_() * 0.01, this.f_19796_.m_188583_() * 0.01, this.f_19796_.m_188583_() * 0.01);
                    }
                }
                this.m_146870_();
            }
        }
        if (this.f_19798_) {
            double len;
            Vec3 step = motion.m_82490_(1.0 / len);
            pos = waterPos.m_82549_(step.m_82490_(0.5));
            for (len = motion.m_82553_(); len > 0.5; len -= 1.0) {
                pos = pos.m_82549_(step);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
            }
        } else {
            motion = motion.m_82490_(0.99);
        }
        this.m_20256_(motion.m_82492_(0.0, 0.05, 0.0));
        this.m_146884_(to);
        this.distanceTravelled = (float)((double)this.distanceTravelled + to.m_82546_(from).m_82553_());
        this.m_20101_();
    }

    public void m_5790_(EntityHitResult hitResult) {
        Entity shooter;
        Entity target = hitResult.m_82443_();
        if (target instanceof Player && (shooter = this.m_19749_()) instanceof Player && !((Player)shooter).m_7099_((Player)target)) {
            target = null;
        }
        if (target != null) {
            shooter = this.m_19749_();
            DamageSource damagesource = this.causeMusketDamage(this, (Entity)(shooter != null ? shooter : this));
            float damage = this.damageMultiplier * (float)this.m_20184_().m_82556_();
            if ((double)damage > 0.5) {
                int oldInvulnerableTime = target.f_19802_;
                if (this.ignoreInvulnerableTime) {
                    target.f_19802_ = 0;
                }
                boolean beenHurt = target.m_6469_(damagesource, damage);
                if (this.ignoreInvulnerableTime && !beenHurt) {
                    target.f_19802_ = oldInvulnerableTime;
                }
            }
        }
    }

    public EntityHitResult findHitEntity(Vec3 start, Vec3 end) {
        Vec3 motion = this.m_20184_();
        Entity resultEntity = null;
        Vec3 resultVec = null;
        double resultDist = 0.0;
        AABB aabbSelection = this.m_20191_().m_82369_(motion).m_82400_(0.5);
        for (Entity entity : this.m_9236_().m_6249_((Entity)this, aabbSelection, x$0 -> this.m_5603_((Entity)x$0))) {
            double dist;
            AABB aabb = entity.m_20191_();
            Optional optional = aabb.m_82371_(start, end);
            if (!optional.isPresent()) {
                aabb = aabb.m_82386_(entity.f_19790_ - entity.m_20185_(), entity.f_19791_ - entity.m_20186_(), entity.f_19792_ - entity.m_20189_());
                optional = aabb.m_82371_(start, end);
            }
            if (!optional.isPresent() || !((dist = start.m_82557_((Vec3)optional.get())) < resultDist) && resultEntity != null) continue;
            resultEntity = entity;
            resultVec = (Vec3)optional.get();
            resultDist = dist;
        }
        return resultEntity != null ? new EntityHitResult(resultEntity, resultVec) : null;
    }

    public void setInitialSpeed(float speed) {
        this.f_19804_.m_135381_(INITIAL_SPEED, (Object)Float.valueOf(speed));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(INITIAL_SPEED, (Object)Float.valueOf(0.0f));
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.damageMultiplier = compound.m_128457_("damageMultiplier");
        this.ignoreInvulnerableTime = compound.m_128445_("ignoreInvulnerableTime") != 0;
        this.distanceTravelled = compound.m_128457_("distanceTravelled");
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("damageMultiplier", this.damageMultiplier);
        compound.m_128344_("ignoreInvulnerableTime", (byte)(this.ignoreInvulnerableTime ? 1 : 0));
        compound.m_128350_("distanceTravelled", this.distanceTravelled);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        Entity owner = this.m_19749_();
        return new ClientboundAddEntityPacket(this.m_19879_(), this.m_20148_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146909_(), this.m_146908_(), this.m_6095_(), owner != null ? owner.m_19879_() : 0, this.m_20184_().m_82490_(4.0 / (double)((Float)this.f_19804_.m_135370_(INITIAL_SPEED)).floatValue()), (double)this.m_6080_());
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        Vec3 packet_velocity = new Vec3(packet.m_131503_(), packet.m_131504_(), packet.m_131505_());
        this.m_20256_(packet_velocity.m_82490_(0.25));
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        super.m_7350_(accessor);
        if (INITIAL_SPEED.equals(accessor) && this.m_9236_().f_46443_) {
            this.m_20256_(this.m_20184_().m_82490_((double)((Float)this.f_19804_.m_135370_(INITIAL_SPEED)).floatValue()));
        }
    }

    static {
        MUSKET = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("musketmod", "musket"));
    }
}

