/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.translations.v0;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.ultreon.libs.commons.v0.Identifier;
import com.ultreon.libs.commons.v0.Logger;
import com.ultreon.libs.registries.v0.Registry;
import com.ultreon.libs.resources.v0.ResourceManager;
import com.ultreon.libs.translations.v0.Language;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class LanguageManager {
    public static final LanguageManager INSTANCE = new LanguageManager();
    public static final Registry<Language> REGISTRY = Registry.create((Identifier)new Identifier("languages"), (Object[])new Language[0]);
    private static Locale currentLanguage;
    private final Map<String, Language> languages = new HashMap<String, Language>();
    private final Set<String> locales = new HashSet<String>();
    private final Set<String> ids = new HashSet<String>();
    private final Map<String, String> locale2id = new HashMap<String, String>();
    private final Map<String, String> id2locale = new HashMap<String, String>();
    public Logger logger = (level, message, t) -> {};

    private LanguageManager() {
    }

    public static Locale getCurrentLanguage() {
        return currentLanguage;
    }

    public static void setCurrentLanguage(Locale currentLanguage) {
        LanguageManager.currentLanguage = currentLanguage;
    }

    public Language load(Locale locale, Identifier id, ResourceManager resourceManager) {
        Gson gson = new Gson();
        String newPath = "languages/" + id.path() + ".json";
        List assets = resourceManager.getAllDataById(id.withPath(newPath));
        JsonObject json = new JsonObject();
        for (byte[] asset : assets) {
            JsonObject object = (JsonObject)gson.fromJson((Reader)new StringReader(new String(asset, StandardCharsets.UTF_8)), JsonObject.class);
            this.recurse(json, object);
        }
        Language language = new Language(locale, json, id);
        this.languages.put(locale.getLanguage(), language);
        REGISTRY.register(id, (Object)language);
        return language;
    }

    public Language load(Locale locale, Identifier id, Reader reader) {
        Gson gson = new Gson();
        String s = "languages/" + id + ".json";
        JsonObject json = (JsonObject)gson.fromJson(reader, JsonObject.class);
        Language language = new Language(locale, json, id);
        this.languages.put(locale.getLanguage(), language);
        REGISTRY.register(id, (Object)language);
        return language;
    }

    public Language get(Locale locale) {
        return this.languages.get(locale.getLanguage());
    }

    public void register(Locale locale, String id) {
        if (this.locales.contains(locale.getLanguage())) {
            this.logger.warn("Locale overridden: " + locale.getLanguage());
        }
        if (this.ids.contains(id)) {
            this.logger.warn("LanguageID overridden: " + id);
        }
        this.locales.add(locale.getLanguage());
        this.ids.add(id);
        this.locale2id.put(locale.getLanguage(), id);
        this.id2locale.put(id, locale.getLanguage());
    }

    public Locale getLocale(String id) {
        return new Locale(this.id2locale.get(id));
    }

    public String getLanguageID(Locale locale) {
        return this.locale2id.get(locale.getLanguage());
    }

    private void recurse(JsonObject json, JsonObject object) {
        for (Map.Entry entry : object.entrySet()) {
            JsonElement value = (JsonElement)entry.getValue();
            String key = (String)entry.getKey();
            if (value instanceof JsonObject) {
                JsonObject obj = (JsonObject)value;
                if (json.has(key) && json.get(key) instanceof JsonObject) {
                    this.recurse(json.getAsJsonObject(key), obj);
                }
            }
            if (value instanceof JsonArray) {
                throw new JsonParseException("Not allowed to have json arrays in language json.");
            }
            json.add(key, value);
        }
    }

    public Set<Locale> getLocales() {
        return this.locales.stream().map(Locale::new).collect(Collectors.toSet());
    }

    public Set<String> getLanguageIDs() {
        return this.ids;
    }

    public List<Language> getLanguages() {
        return new ArrayList<Language>(this.languages.values());
    }
}

