/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.commons.v0.util;

import com.ultreon.libs.commons.v0.UtilityClass;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.jetbrains.annotations.NotNull;

public final class TimeUtils
extends UtilityClass {
    public static String formatDuration(long duration) {
        LocalDateTime g = LocalDateTime.ofEpochSecond(duration, 0, ZoneOffset.ofTotalSeconds(0));
        int minute = g.getMinute();
        int second = g.getSecond();
        double hourDouble = (double)duration / 60.0 / 60.0;
        return TimeUtils.formatDuration(minute, second, hourDouble);
    }

    @NotNull
    public static String formatDuration(int minute, int second, double hourDouble) {
        hourDouble -= (double)minute / 60.0;
        int hour = (int)(hourDouble -= (double)second / 60.0 / 60.0);
        String minuteString = Integer.toString(minute);
        String secondString = Integer.toString(second);
        if (minuteString.length() == 1) {
            minuteString = "0" + minuteString;
        }
        if (secondString.length() == 1) {
            secondString = "0" + secondString;
        }
        return hour + ":" + minuteString + ":" + secondString;
    }
}

