/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.commons.v0;

import java.io.Serializable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class Progress
implements Cloneable,
Comparable<Progress>,
Serializable {
    private int progress;
    private final int max;

    public Progress(int max) {
        this(0, max);
    }

    public Progress(int progress, int max) {
        this.progress = progress;
        this.max = max;
    }

    public void increment() {
        if (this.progress + 1 <= this.max) {
            ++this.progress;
        } else {
            throw new IllegalStateException("Progress increment at end: " + (this.progress + 1) + ", max: " + this.max);
        }
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMax() {
        return this.max;
    }

    public float getPercentage() {
        return 100.0f * (float)this.progress / (float)this.max;
    }

    public float getRelativeProgress() {
        return (float)this.progress / (float)this.max;
    }

    private int getTodo() {
        return Math.max(this.max - this.progress, 0);
    }

    public String toString() {
        return "Progress{progress=" + this.progress + ", max=" + this.max + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Progress progress1 = (Progress)o;
        return this.getProgress() == progress1.getProgress() && this.getMax() == progress1.getMax();
    }

    public int hashCode() {
        return Objects.hash(this.getProgress(), this.getMax());
    }

    @Override
    public int compareTo(@NotNull Progress o) {
        return 0;
    }

    protected Progress clone() throws CloneNotSupportedException {
        return (Progress)super.clone();
    }
}

