/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.collections.v0.util;

import com.ultreon.libs.collections.v0.iterator.DoubleIterable;
import com.ultreon.libs.collections.v0.iterator.DoubleIterator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class Range {
    private final double start;
    private final double end;
    private final double step;

    Range(double start, double end, double step) {
        this.start = start;
        this.end = end;
        this.step = step;
    }

    public double start() {
        return this.start;
    }

    public double end() {
        return this.end;
    }

    public double step() {
        return this.step;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Range that = (Range)obj;
        return Double.doubleToLongBits(this.start) == Double.doubleToLongBits(that.start) && Double.doubleToLongBits(this.end) == Double.doubleToLongBits(that.end) && Double.doubleToLongBits(this.step) == Double.doubleToLongBits(that.step);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end, this.step);
    }

    public String toString() {
        return "Range[start=" + this.start + ", end=" + this.end + ", step=" + this.step + ']';
    }

    public Range(double start, double end) {
        this(start, end, 1.0);
    }

    public Range(double end) {
        this(0.0, end);
    }

    public boolean contains(double value) {
        return this.start <= value && this.end > value;
    }

    @NotNull
    public DoubleIterator iterator() {
        return new DoubleIterator(){
            private double current;
            {
                this.current = Range.this.start;
            }

            @Override
            public boolean hasNext() {
                return this.current < Range.this.end;
            }

            @Override
            public double nextDouble() {
                return this.current += Range.this.step;
            }
        };
    }

    public DoubleIterable iterable() {
        return this::iterator;
    }
}

